<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "settlement".
 *
 * @property integer $settlement_id
 * @property string $name
 * @property string $sign
 *
 * @property SettlementAddressLink[] $settlementAddressLinks
 */
class Settlement extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'settlement';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name', 'sign'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'settlement_id' => 'Settlement ID',
            'name' => 'Name',
            'sign' => 'Sign',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlementAddressLinks()
    {
        return $this->hasMany(SettlementAddressLink::className(), ['settlement_id' => 'settlement_id'])->inverseOf('settlement');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFlowIntensities()
    {
        return $this->hasOne(FlowIntensity::className(), [ 'settlement_id' => 'settlement_id' ])
                    ->inverseOf('settlement');
    }
}
