<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "service_object_type".
 *
 * @property integer $service_object_type_id
 * @property string $name
 *
 * @property ServiceObject[] $serviceObjects
 */
class ServiceObjectType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'service_object_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'service_object_type_id' => 'Service Object Type ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getServiceObjects()
    {
        return $this->hasMany(ServiceObject::className(), ['service_object_type_id' => 'service_object_type_id']);
    }
}
