<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ServiceObject;

/**
 * ServiceObjectSearch represents the model behind the search form about `common\models\ServiceObject`.
 */
class ServiceObjectSearch extends ServiceObject
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['service_object_id', 'road_id', 'region_id', 'service_object_type_id', 'settlement_id', 'department_affiliation_id'], 'integer'],
            [['location_right', 'location_left', 'location_axis', 'distance', 'capacity'], 'number'],
            [['arrangement_elements'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ServiceObject::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'service_object_id' => $this->service_object_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'service_object_type_id' => $this->service_object_type_id,
            'settlement_id' => $this->settlement_id,
            'department_affiliation_id' => $this->department_affiliation_id,
            'location_right' => $this->location_right,
            'location_left' => $this->location_left,
            'location_axis' => $this->location_axis,
            'distance' => $this->distance,
            'capacity' => $this->capacity,
        ]);

        $query->andFilterWhere(['like', 'arrangement_elements', $this->arrangement_elements]);

        return $dataProvider;
    }
}
