<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "service_object".
 *
 * @property integer $service_object_id
 * @property integer $road_id
 * @property integer $region_id
 * @property integer $service_object_type_id
 * @property integer $settlement_id
 * @property integer $department_affiliation_id
 * @property double $location_right
 * @property double $location_left
 * @property double $location_axis
 * @property double $distance
 * @property double $capacity
 * @property string $arrangement_elements
 *
 * @property DepartmentAffiliation $departmentAffiliation
 * @property Region $region
 * @property Road $road
 * @property ServiceObjectType $serviceObjectType
 * @property Settlement $settlement
 */
class ServiceObject extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'service_object';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_id', 'region_id', 'service_object_type_id', 'settlement_id', 'department_affiliation_id'], 'integer'],
            [['location_right', 'location_left', 'location_axis', 'distance', 'capacity'], 'number'],
            [['arrangement_elements'], 'string'],
            [['department_affiliation_id'], 'exist', 'skipOnError' => true, 'targetClass' => DepartmentAffiliation::className(), 'targetAttribute' => ['department_affiliation_id' => 'department_affiliation_id']],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
            [['service_object_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => ServiceObjectType::className(), 'targetAttribute' => ['service_object_type_id' => 'service_object_type_id']],
            [['settlement_id'], 'exist', 'skipOnError' => true, 'targetClass' => Settlement::className(), 'targetAttribute' => ['settlement_id' => 'settlement_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'service_object_id' => 'Індекс',
            'road_id' => 'Дорога',
            'region_id' => 'Область',
            'service_object_type_id' => 'Вид споруди чи об\'єкту',
            'settlement_id' => 'Назва підприємства та населеного пункту',
            'department_affiliation_id' => 'Відоча приналежність',
            'location_right' => 'Місцезнаходження, км+ справа',
            'location_left' => 'Місцезнаходження, км+ зліва',
            'location_axis' => 'Місцезнаходження, км+ по осі',
            'distance' => 'Відстань до об\'єкту від вісі дор., м',
            'capacity' => 'Потужність',
            'arrangement_elements' => 'Елементи облаштування',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDepartmentAffiliation()
    {
        return $this->hasOne(DepartmentAffiliation::className(), ['department_affiliation_id' => 'department_affiliation_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getServiceObjectType()
    {
        return $this->hasOne(ServiceObjectType::className(), ['service_object_type_id' => 'service_object_type_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlement()
    {
        return $this->hasOne(Settlement::className(), ['settlement_id' => 'settlement_id']);
    }

    public function getLeftString()
    {
        return floor($this->location_left) . '+' . ( str_pad(round(( $this->location_left - floor($this->location_left) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getRightString()
    {
        return floor($this->location_right) . '+' . ( str_pad(round(( $this->location_right - floor($this->location_right) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getAxisString()
    {
        return floor($this->location_axis) . '+' . ( str_pad(round(( $this->location_axis - floor($this->location_axis) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }
}
