<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_type".
 *
 * @property integer $road_type_id
 * @property string $value
 *
 * @property Road[] $roads
 */
class RoadType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['value'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_type_id' => 'Road Type ID',
            'value' => 'Тип дороги',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoads()
    {
        return $this->hasMany(Road::className(), ['road_type_id' => 'road_type_id'])->inverseOf('roadType');
    }
}
