<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_to_category".
 *
 * @property integer $road_to_category_id
 * @property integer $region_id
 * @property integer $road_id
 * @property double $begin
 * @property double $end
 * @property double $distance
 * @property integer $road_category_id
 *
 * @property Region $region
 * @property Road $road
 * @property RoadCategory $roadCategory
 */
class RoadToCategory extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_to_category';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['region_id', 'road_id', 'road_category_id'], 'integer'],
            [['begin', 'end', 'distance'], 'number'],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
            [['road_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoadCategory::className(), 'targetAttribute' => ['road_category_id' => 'road_category_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_to_category_id' => 'Індекс',
            'region_id' => 'Область',
            'road_id' => 'Дорога',
            'begin' => 'Місцезнаходження, км+ початок',
            'end' => 'Місцезнаходження, км+ кінець',
            'distance' => 'Протяжність, км',
            'road_category_id' => 'Категорія',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadCategory()
    {
        return $this->hasOne(RoadCategory::className(), ['road_category_id' => 'road_category_id']);
    }

    public function getBeginString()
    {
        return floor($this->begin) . '+' . ( str_pad(round(( $this->begin - floor($this->begin) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getEndString()
    {
        return floor($this->end) . '+' . ( str_pad(round(( $this->end - floor($this->end) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }
}
