<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_surface".
 *
 * @property integer $road_surface_id
 * @property integer $road_id
 * @property integer $region_id
 * @property integer $road_direction_id
 * @property double $begin
 * @property double $end
 * @property integer $surface_type_id
 * @property integer $surface_treatment_id
 * @property integer $state_common_id
 *
 * @property Region $region
 * @property Road $road
 * @property RoadDirection $roadDirection
 * @property StateCommon $stateCommon
 * @property SurfaceTreatment $surfaceTreatment
 * @property SurfaceType $surfaceType
 */
class RoadSurface extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_surface';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_id', 'region_id', 'road_direction_id', 'surface_type_id', 'surface_treatment_id', 'state_common_id'], 'integer'],
            [['begin', 'end'], 'number'],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
            [['road_direction_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoadDirection::className(), 'targetAttribute' => ['road_direction_id' => 'road_direction_id']],
            [['state_common_id'], 'exist', 'skipOnError' => true, 'targetClass' => StateCommon::className(), 'targetAttribute' => ['state_common_id' => 'state_common_id']],
            [['surface_treatment_id'], 'exist', 'skipOnError' => true, 'targetClass' => SurfaceTreatment::className(), 'targetAttribute' => ['surface_treatment_id' => 'surface_treatment_id']],
            [['surface_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => SurfaceType::className(), 'targetAttribute' => ['surface_type_id' => 'surface_type_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_surface_id' => 'Індекс',
            'road_id' => 'Дорога',
            'region_id' => 'Область',
            'road_direction_id' => 'Напрямок смуги руху',
            'begin' => 'Місцезнаходження, км+ початок',
            'end' => 'Місцезнаходження, км+ кінець',
            'surface_type_id' => 'Тип покриття',
            'surface_treatment_id' => 'Тип поверхневої обробки',
            'state_common_id' => 'Стан покриття',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadDirection()
    {
        return $this->hasOne(RoadDirection::className(), ['road_direction_id' => 'road_direction_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStateCommon()
    {
        return $this->hasOne(StateCommon::className(), ['state_common_id' => 'state_common_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSurfaceTreatment()
    {
        return $this->hasOne(SurfaceTreatment::className(), ['surface_treatment_id' => 'surface_treatment_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSurfaceType()
    {
        return $this->hasOne(SurfaceType::className(), ['surface_type_id' => 'surface_type_id']);
    }
    
    public function getBeginString()
    {
        return floor($this->begin) . '+' . ( str_pad(round(( $this->begin - floor($this->begin) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getEndString()
    {
        return floor($this->end) . '+' . ( str_pad(round(( $this->end - floor($this->end) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }
}
