<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\RoadService;

/**
 * RoadServiceSearch represents the model behind the search form about `common\models\RoadService`.
 */
class RoadServiceSearch extends RoadService
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_service_id', 'road_id', 'region_id', 'road_direction_id', 'organization_id', 'year_begin'], 'integer'],
            [['begin', 'end'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = RoadService::find()->joinWith(['road', 'region', 'organization', 'roadDirection']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'road_service_id' => $this->road_service_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'begin' => $this->begin,
            'end' => $this->end,
            'road_direction_id' => $this->road_direction_id,
            'organization_id' => $this->organization_id,
            'year_begin' => $this->year_begin,
        ]);

        return $dataProvider;
    }
}
