<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_passport".
 *
 * @property integer $road_passport_id
 * @property integer $road_id
 * @property integer $region_id
 * @property string $begin
 * @property string $end
 *
 * @property Point[] $points
 * @property Region $region
 * @property Road $road
 */
class RoadPassport extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_passport';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_id', 'region_id', 'begin'], 'required'],
            [['road_id', 'region_id'], 'integer'],
            [['begin', 'end'], 'number'],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_passport_id' => 'Road Passport ID',
            'road_id' => 'Дорога',
            'region_id' => 'Область',
            'begin' => 'Початок (км+)',
            'end' => 'Кінець (км+)',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPoints()
    {
        return $this->hasMany(Point::className(), ['road_passport_id' => 'road_passport_id'])->inverseOf('roadPassport');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id'])->inverseOf('roadPassports');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id'])->inverseOf('roadPassports');
    }
}
