<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_direction".
 *
 * @property integer $road_direction_id
 * @property string $direction_name
 *
 * @property RoadService[] $roadServices
 */
class RoadDirection extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_direction';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['direction_name'], 'required'],
            [['direction_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_direction_id' => 'Road Direction ID',
            'direction_name' => 'Direction Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadServices()
    {
        return $this->hasMany(RoadService::className(), ['road_direction_id' => 'road_direction_id'])->inverseOf('roadDirection');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFlowIntensities()
    {
        return $this->hasOne(FlowIntensity::className(), [ 'road_direction_id' => 'road_direction_id' ])
                    ->inverseOf('roadDirection');
    }
}
