<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_category".
 *
 * @property integer $road_category_id
 * @property string $value
 *
 * @property Road[] $roads
 */
class RoadCategory extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_category';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['value'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_category_id' => 'Road Category ID',
            'value' => 'Категорія дороги',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoads()
    {
        return $this->hasMany(Road::className(), ['road_category_id' => 'road_category_id'])->inverseOf('roadCategory');
    }
}
