<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\FlowIntensity;

/**
 * FlowIntensitySearch represents the model behind the search form about `common\models\FlowIntensity`.
 */
class FlowIntensitySearch extends FlowIntensity
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['flow_intensity_id', 'road_id', 'region_id', 'road_direction_id', 'settlement_id', 'intensity_total', 'intensity_increase', 'intensity_moto', 'intensity_moto_sidecar', 'intensity_car', 'intensity_truck_two', 'intensity_truck_two_six', 'intensity_truck_six_eight', 'intensity_truck_eight_fourteen', 'intensity_truck_fourteen', 'intensity_lorry_twelve', 'intensity_lorry_twelve_twenty', 'intensity_lorry_twenty_thirty', 'intensity_lorry_thirty', 'intensity_tractor_under_ten', 'intensity_tractor_over_ten', 'intensity_bus', 'intensity_bus_coupled', 'date_add'], 'integer'],
            [['location', 'begin', 'end'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FlowIntensity::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'flow_intensity_id' => $this->flow_intensity_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'location' => $this->location,
            'begin' => $this->begin,
            'end' => $this->end,
            'road_direction_id' => $this->road_direction_id,
            'settlement_id' => $this->settlement_id,
            'intensity_total' => $this->intensity_total,
            'intensity_increase' => $this->intensity_increase,
            'intensity_moto' => $this->intensity_moto,
            'intensity_moto_sidecar' => $this->intensity_moto_sidecar,
            'intensity_car' => $this->intensity_car,
            'intensity_truck_two' => $this->intensity_truck_two,
            'intensity_truck_two_six' => $this->intensity_truck_two_six,
            'intensity_truck_six_eight' => $this->intensity_truck_six_eight,
            'intensity_truck_eight_fourteen' => $this->intensity_truck_eight_fourteen,
            'intensity_truck_fourteen' => $this->intensity_truck_fourteen,
            'intensity_lorry_twelve' => $this->intensity_lorry_twelve,
            'intensity_lorry_twelve_twenty' => $this->intensity_lorry_twelve_twenty,
            'intensity_lorry_twenty_thirty' => $this->intensity_lorry_twenty_thirty,
            'intensity_lorry_thirty' => $this->intensity_lorry_thirty,
            'intensity_tractor_under_ten' => $this->intensity_tractor_under_ten,
            'intensity_tractor_over_ten' => $this->intensity_tractor_over_ten,
            'intensity_bus' => $this->intensity_bus,
            'intensity_bus_coupled' => $this->intensity_bus_coupled,
            'date_add' => $this->date_add,
        ]);

        return $dataProvider;
    }
}
