<?php

    namespace common\models;

    use Yii;
    use yii\behaviors\TimestampBehavior;

    /**
     * This is the model class for table "flow_intensity".
     * @property integer       $flow_intensity_id
     * @property integer       $road_id
     * @property integer       $region_id
     * @property double        $location
     * @property double        $begin
     * @property double        $end
     * @property integer       $road_direction_id
     * @property integer       $settlement_id
     * @property integer       $intensity_total
     * @property integer       $intensity_increase
     * @property integer       $intensity_moto
     * @property integer       $intensity_moto_sidecar
     * @property integer       $intensity_car
     * @property integer       $intensity_truck_two
     * @property integer       $intensity_truck_two_six
     * @property integer       $intensity_truck_six_eight
     * @property integer       $intensity_truck_eight_fourteen
     * @property integer       $intensity_truck_fourteen
     * @property integer       $intensity_lorry_twelve
     * @property integer       $intensity_lorry_twelve_twenty
     * @property integer       $intensity_lorry_twenty_thirty
     * @property integer       $intensity_lorry_thirty
     * @property integer       $intensity_tractor_under_ten
     * @property integer       $intensity_tractor_over_ten
     * @property integer       $intensity_bus
     * @property integer       $intensity_bus_coupled
     * @property integer       $date_add
     * @property Region        $region
     * @property Road          $road
     * @property RoadDirection $roadDirection
     * @property Settlement    $settlement
     */
    class FlowIntensity extends \yii\db\ActiveRecord
    {

        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'flow_intensity';
        }

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                [
                    'class'              => TimestampBehavior::className(),
                    'createdAtAttribute' => 'date_add',
                    'updatedAtAttribute' => false,
                ],
            ];
        }

        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'road_id',
                        'region_id',
                        'road_direction_id',
                        'settlement_id',
                        'intensity_total',
                        'intensity_increase',
                        'intensity_moto',
                        'intensity_moto_sidecar',
                        'intensity_car',
                        'intensity_truck_two',
                        'intensity_truck_two_six',
                        'intensity_truck_six_eight',
                        'intensity_truck_eight_fourteen',
                        'intensity_truck_fourteen',
                        'intensity_lorry_twelve',
                        'intensity_lorry_twelve_twenty',
                        'intensity_lorry_twenty_thirty',
                        'intensity_lorry_thirty',
                        'intensity_tractor_under_ten',
                        'intensity_tractor_over_ten',
                        'intensity_bus',
                        'intensity_bus_coupled',
                    ],
                    'integer',
                ],
                [
                    [
                        'location',
                        'begin',
                        'end',
                    ],
                    'number',
                ],
                [
                    [ 'region_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Region::className(),
                    'targetAttribute' => [ 'region_id' => 'region_id' ],
                ],
                [
                    [ 'road_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Road::className(),
                    'targetAttribute' => [ 'road_id' => 'road_id' ],
                ],
                [
                    [ 'road_direction_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => RoadDirection::className(),
                    'targetAttribute' => [ 'road_direction_id' => 'road_direction_id' ],
                ],
                [
                    [ 'settlement_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Settlement::className(),
                    'targetAttribute' => [ 'settlement_id' => 'settlement_id' ],
                ],
            ];
        }

        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'flow_intensity_id'              => 'Індекс',
                'road_id'                        => 'Автомобільна дорога',
                'region_id'                      => 'Область',
                'location'                       => 'Місцезнаходження, км+',
                'begin'                          => 'Місцезнаходження ділянки з однорідною інтенсивністю руху, км+, початок',
                'end'                            => 'Місцезнаходження ділянки з однорідною інтенсивністю руху, км+, кінець',
                'road_direction_id'              => 'Напрямок смуги руху',
                'settlement_id'                  => 'Найближчий населений пункт',
                'intensity_total'                => 'Інтенсивність руху, авт/добу, всього',
                'intensity_increase'             => 'Інтенсивність руху, авт/добу, приріст',
                'intensity_moto'                 => 'Інтенсивність руху, авт/добу, мотоцикл без коляски та мопед',
                'intensity_moto_sidecar'         => 'Інтенсивність руху, авт/добу, мотоцикл з коляскою',
                'intensity_car'                  => 'Інтенсивність руху, авт/добу, легковий автомобіль',
                'intensity_truck_two'            => 'Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: до 2 т.',
                'intensity_truck_two_six'        => 'Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 2 т. до 6 т.',
                'intensity_truck_six_eight'      => 'Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 6 т. до 8 т.',
                'intensity_truck_eight_fourteen' => 'Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 8 т. до 14 т.',
                'intensity_truck_fourteen'       => 'Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: понад 14 т.',
                'intensity_lorry_twelve'         => 'Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: до 12 т.',
                'intensity_lorry_twelve_twenty'  => 'Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: від 12 т. до 20 т.',
                'intensity_lorry_twenty_thirty'  => 'Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: від 20 т. до 30 т.',
                'intensity_lorry_thirty'         => 'Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: понад 30 т.',
                'intensity_tractor_under_ten'    => 'Інтенсивність руху, авт/добу, колісний трактор з причепами до 10 т.',
                'intensity_tractor_over_ten'     => 'Інтенсивність руху, авт/добу, колісний трактор з причепами понад 10 т.',
                'intensity_bus'                  => 'Інтенсивність руху, авт/добу, автобус, тролейбус',
                'intensity_bus_coupled'          => 'Інтенсивність руху, авт/добу, автобус зчеплений (здвоєний)',
                'date_add'                       => 'Дата визначення',
            ];
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRegion()
        {
            return $this->hasOne(Region::className(), [ 'region_id' => 'region_id' ])
                        ->inverseOf('flowIntensities');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRoad()
        {
            return $this->hasOne(Road::className(), [ 'road_id' => 'road_id' ])
                        ->inverseOf('flowIntensities');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRoadDirection()
        {
            return $this->hasOne(RoadDirection::className(), [ 'road_direction_id' => 'road_direction_id' ])
                        ->inverseOf('flowIntensities');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getSettlement()
        {
            return $this->hasOne(Settlement::className(), [ 'settlement_id' => 'settlement_id' ])
                        ->inverseOf('flowIntensities');
        }

        public function getLocationString()
        {
            return floor($this->location) . '+' . ( str_pad(round(( $this->location - floor($this->location) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }

        public function getBeginString()
        {
            return floor($this->begin) . '+' . ( str_pad(round(( $this->begin - floor($this->begin) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }

        public function getEndString()
        {
            return floor($this->end) . '+' . ( str_pad(round(( $this->end - floor($this->end) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }
    }
