<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\CrossSection;

/**
 * CrossSectionSearch represents the model behind the search form about `common\models\CrossSection`.
 */
class CrossSectionSearch extends CrossSection
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cross_section_id', 'region_id', 'road_id', 'surface_type_id', 'tube_availability', 'safety_availability', 'year_build', 'year_repair', 'state_common_id'], 'integer'],
            [['location_left', 'location_right', 'length_section', 'length_surface', 'distance_edge', 'width', 'angle'], 'number'],
            [['direction'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = CrossSection::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'cross_section_id' => $this->cross_section_id,
            'region_id' => $this->region_id,
            'road_id' => $this->road_id,
            'location_left' => $this->location_left,
            'location_right' => $this->location_right,
            'surface_type_id' => $this->surface_type_id,
            'length_section' => $this->length_section,
            'length_surface' => $this->length_surface,
            'distance_edge' => $this->distance_edge,
            'width' => $this->width,
            'angle' => $this->angle,
            'tube_availability' => $this->tube_availability,
            'safety_availability' => $this->safety_availability,
            'year_build' => $this->year_build,
            'year_repair' => $this->year_repair,
            'state_common_id' => $this->state_common_id,
        ]);

        $query->andFilterWhere(['like', 'direction', $this->direction]);

        return $dataProvider;
    }
}
