<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\BusStop;

/**
 * BusStopSearch represents the model behind the search form about `common\models\BusStop`.
 */
class BusStopSearch extends BusStop
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['bus_stop_id', 'road_id', 'region_id', 'settlement_id', 'surface_type_id', 'area_stop_availability', 'area_land_availability', 'pocket_availability', 'toilet_availability', 'year_build', 'year_repair', 'state_common_id'], 'integer'],
            [['location_right', 'location_left'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = BusStop::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'bus_stop_id' => $this->bus_stop_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'settlement_id' => $this->settlement_id,
            'location_right' => $this->location_right,
            'location_left' => $this->location_left,
            'surface_type_id' => $this->surface_type_id,
            'area_stop_availability' => $this->area_stop_availability,
            'area_land_availability' => $this->area_land_availability,
            'pocket_availability' => $this->pocket_availability,
            'toilet_availability' => $this->toilet_availability,
            'year_build' => $this->year_build,
            'year_repair' => $this->year_repair,
            'state_common_id' => $this->state_common_id,
        ]);

        return $dataProvider;
    }
}
