var road_passports = [];
$(document).on('click', '#control .show-route', function() {
    var id = $(this).data('key');
    if(id in road_passports) {
        clearMarkers();
        road_passports[id].forEach(function(element, index) {
            if(element == undefined) {
                return false;
            }
            var marker = new google.maps.Marker(
                {
                    position : {
                        lat : parseFloat(element.lat),
                        lng : parseFloat(element.lng)
                    },
                    title : '#' + parseInt(element.num),
                    map : null,
                    draggable : false,
                    label : parseInt(element.num).toString(10)
                }
            );
            markers.push(marker);
        });
        repaint();
        fitBounds();
        showMap();
    } else {
        $.get(points_url, {
            id: id
        }, function(data) {
            road_passports[id] = new google.maps.MVCArray();
            if(data.result.passport) {
                road_passports[id].model = createPassportModel();
                fillPassportModel(id, data.result.passport);
            }
            road_passports[id].setAt(0, undefined);
            clearMarkers();
            $.each(
                data.result.points, function(index, value)
                {
                    road_passports[id].setAt(index, value);
                    var marker = new google.maps.Marker(
                        {
                            position : {
                                lat : parseFloat(value.lat),
                                lng : parseFloat(value.lng)
                            },
                            title : '#' + parseInt(value.num),
                            map : null,
                            draggable : false,
                            label : parseInt(value.num).toString(10)
                        }
                    );
                    markers.push(marker);
                }
            );
            repaint();
            fitBounds();
            showMap();
        });
    }
});