<?php
    /**
     * @var View               $this
     * @var ActiveDataProvider $dataProvider
     */
    use common\models\RoadPassport;
    use frontend\assets\StatementAsset;
    use yii\data\ActiveDataProvider;
    use yii\grid\GridView;
    use yii\helpers\Html;
    use yii\helpers\Url;
    use yii\web\View;

    $points_url = Url::to(['point/get']);
    $this->registerJs("var points_url = '".$points_url."';", $this::POS_HEAD);
    $this->title = 'My Yii Application';
    StatementAsset::register($this);
?>
<div class="controls">

</div>
<div class="site-index">
    <div class="col-xs-12 top_control">

    </div>
    <div class="col-xs-12">
        <div id="map">
        
        </div>
    </div>
    <div class="col-xs-12">
        <div id="control">
            <p class="h3 text-center">
                Відомість
            </p>
            <p class="text-center">
                автомобільних доріг станом на
                <ins class="bold"><?php echo date('d F Y') . ' р.'; ?></ins>
            </p>
            <?php
                echo GridView::widget([
                    'dataProvider' => $dataProvider,
                    'columns'      => [
                        [
                            'attribute' => 'road.index',
                            'value'     => function($model, $key, $index, $column) {
                                /**
                                 * @var RoadPassport $model
                                 */
                                $value = '';
                                $value .= $model->road->roadType->value;
                                $value .= '-';
                                $value .= str_pad($model->road->index, 2, '0', STR_PAD_LEFT);
                                return $value;
                            },
                            'label'     => 'Державний індекс та номер',
                        ],
                        [
                            'attribute' => 'road.name',
                        ],
                        [
                            'attribute' => 'road.roadType.definition',
                            'label'     => 'Народно-господарське значення',
                        ],
                        [
                            'attribute' => 'begin',
                            'value'     => function($model, $key, $index, $column) {
                                /**
                                 * @var RoadPassport $model
                                 */
                                $value = floor($model->begin) . '+';
                                $value .= str_pad(( $model->begin - floor($model->begin) ) * 1000, 3, '0', STR_PAD_LEFT);
                                return $value;
                            },
                        ],
                        [
                            'attribute' => 'end',
                            'value'     => function($model, $key, $index, $column) {
                                /**
                                 * @var RoadPassport $model
                                 */
                                $value = floor($model->end) . '+';
                                $value .= str_pad(( $model->end - floor($model->end) ) * 1000, 3, '0', STR_PAD_LEFT);
                                return $value;
                            },
                        ],
                        [
                            'class'   => 'yii\grid\Column',
                            'header'  => 'Траса',
                            'content' => function($model, $key, $index, $column) {
                                return Html::tag('span', '', [
                                    'class' => 'glyphicon glyphicon-road show-route',
                                    'data' => [
                                        'key' => $key,
                                    ],
                                ]);
                            },
                        ],
                    ],
                ])
            ?>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
