<?php

    use yii\helpers\Html;

    /**
     * @var yii\web\View                        $this
     * @var common\models\SettlementAddressLink $model
     * @var array                               $roads
     * @var array                               $regions
     * @var array                               $settlement_locations
     * @var array                               $settlements
     */

    $this->title = 'Update Settlement Address Link: ' . $model->settlement_address_link_id;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Settlement Address Links',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->settlement_address_link_id,
        'url'   => [
            'view',
            'id' => $model->settlement_address_link_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Update';
?>
<div class="settlement-address-link-update">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model'                => $model,
        'roads'                => $roads,
        'regions'              => $regions,
        'settlement_locations' => $settlement_locations,
        'settlements'          => $settlements,
    ]) ?>

</div>
