<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    /**
     * @var yii\web\View                        $this
     * @var common\models\SettlementAddressLink $model
     * @var array                               $roads
     * @var array                               $regions
     * @var array                               $settlement_locations
     * @var array                               $settlements
     * @var yii\widgets\ActiveForm              $form
     */

?>

<div class="settlement-address-link-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'begin')
             ->textInput() ?>

    <?= $form->field($model, 'end')
             ->textInput() ?>

    <?= $form->field($model, 'settlement_location_id')
             ->dropDownList($settlement_locations) ?>

    <?= $form->field($model, 'settlement_id')
             ->dropDownList($settlements) ?>

    <?= $form->field($model, 'distance')
             ->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Створити' : 'Оновити', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
