<?php

    use common\models\ServiceObject;
    use yii\helpers\Html;
    use yii\grid\GridView;

    /* @var $this yii\web\View */
    /* @var $searchModel common\models\ServiceObjectSearch */
    /* @var $dataProvider yii\data\ActiveDataProvider */

    $this->title = 'Об\'єкти сервісу';
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="service-object-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Service Object', [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel'  => $searchModel,
        'columns'      => [
            [ 'class' => 'yii\grid\SerialColumn' ],
            [
                'attribute' => 'location_right',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->getRightString();
                },
            ],
            [
                'attribute' => 'location_left',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->getLeftString();
                },
            ],
            [
                'attribute' => 'location_axis',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->getAxisString();
                },
            ],
            [
                'attribute' => 'road_id',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->road->name;
                },
            ],
            [
                'attribute' => 'region_id',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->region->name;
                },
            ],
            [
                'attribute' => 'service_object_type_id',
                'value'     => function($model) {
                    /**
                     * @var ServiceObject $model
                     */
                    return $model->serviceObjectType->name;
                },
            ],
            [ 'class' => 'yii\grid\ActionColumn' ],
        ],
    ]); ?>
</div>
