<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View                $this
     * @var common\models\ServiceObject $model
     * @var array                       $roads
     * @var array                       $regions
     * @var array                       $service_object_types
     * @var array                       $settlements
     * @var array                       $department_affiliations
     * @var yii\widgets\ActiveForm      $form
     */
?>

<div class="service-object-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'service_object_type_id')
             ->dropDownList($service_object_types) ?>

    <?= $form->field($model, 'settlement_id')
             ->dropDownList($settlements, ['prompt' => 'Нет']) ?>

    <?= $form->field($model, 'department_affiliation_id')
             ->dropDownList($department_affiliations) ?>

    <?= $form->field($model, 'location_right')
             ->textInput() ?>

    <?= $form->field($model, 'location_left')
             ->textInput() ?>

    <?= $form->field($model, 'location_axis')
             ->textInput() ?>

    <?= $form->field($model, 'distance')
             ->textInput() ?>

    <?= $form->field($model, 'capacity')
             ->textInput() ?>

    <?= $form->field($model, 'arrangement_elements')
             ->textarea([ 'rows' => 6 ]) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
