<?php

    /**
     * @var Road               $road
     * @var Region             $region
     * @var ActiveDataProvider $dataProvider
     */

    use common\models\Region;
    use common\models\Road;
    use common\models\ServiceObject;
    use common\models\SettlementAddressLink;
    use yii\bootstrap\Html;
    use yii\data\ActiveDataProvider;
    use yii\grid\GridView;
    use yii\widgets\DetailView;

    $this->title = $road->name;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Дороги',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $this->title,
        'url'   => [
            'view',
            'id' => $road->road_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Відомість наявності споруд автослужб, об\'єктів сервісу - ' . ucfirst($region->name) . ' область';
?>
<div class="site-index">
    <div class="col-xs-6 text-center">
        Міністрество транспорту України <br>
        Державна служба автомобільних доріг <br>
        України
    </div>
    <div class="col-xs-6 text-center">
        Служба автомобільних доріг у <?php echo $region->name; ?> області
    </div>
    <div class="clearfix"></div>
    <div class="col-xs-12 text-center">
        <p class="h3">Відомість</p>
        <p>наявносіті</p>
        <p><b>споруд автослужб, об'єктів сервісу</b></p>
        <p>на автомобільній дорозі</p>
        <p>
            <ins><?php echo $road->name; ?></ins>
        </p>
        <p>
            <ins><?php echo $road->roadType->definition; ?></ins>
            значення станом на
            <ins><?php echo date('d F Y'); ?> р.</ins>
        </p>
    </div>
    <div class="col-xs-12 text-center">
        <?php
            echo GridView::widget([
                'dataProvider' => $dataProvider,
                'layout'       => "{items}",
                'columns'      => [
                    [
                        'attribute' => 'location_right',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            return $model->getRightString();
                        },
                    ],
                    [
                        'attribute' => 'location_axis',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            return $model->getAxisString();
                        },
                    ],
                    [
                        'attribute' => 'location_left',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            return $model->getLeftString();
                        },
                    ],
                    [
                        'attribute' => 'service_object_type_id',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            return $model->serviceObjectType->name;
                        },
                    ],
                    [
                        'attribute' => 'settlement_id',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            if(!empty($model->settlement->name)) {
                                return $model->settlement->name;
                            } else {
                                return false;
                            }
                        },
                    ],
                    'distance',
                    'capacity',
                    [
                        'attribute' => 'department_affiliation_id',
                        'value'     => function($model) {
                            /**
                             * @var ServiceObject $model
                             */
                            return $model->departmentAffiliation->name;
                        },
                    ],
                    'arrangement_elements',
                ],
            ]);
        ?>
    </div>
</div>
