<?php

    /**
     * @var Road               $road
     * @var Region             $region
     * @var ActiveDataProvider $dataProvider
     */

    use common\models\Region;
    use common\models\Road;
    use common\models\SettlementAddressLink;
    use yii\data\ActiveDataProvider;
    use yii\grid\GridView;
use common\models\RoadToCategory;

    $this->title = $road->name;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Дороги',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $this->title,
        'url'   => [
            'view',
            'id' => $road->road_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Відомість адресної прив\'язки населених пунктів - ' . ucfirst($region->name). ' область';
?>
<div class="site-index">
    <div class="col-xs-6 text-center">
        Міністрество транспорту України <br>
        Державна служба автомобільних доріг <br>
        України
    </div>
    <div class="col-xs-6 text-center">
        Служба автомобільних доріг у <?php echo $region->name; ?> області
    </div>
    <div class="clearfix"></div>
    <div class="col-xs-12 text-center">
        <p class="h3">Відомість</p>
        <p class="text-center"><b>адресної прив'язки населених пунктів</b></p>
        <p>на автомобільній дорозі</p>
        <p><ins><?php echo $road->name; ?></ins></p>
        <p><ins><?php echo $road->roadType->definition;?></ins> значення станом на <ins><?php echo date('d F Y');?> р.</ins></p>
    </div>
    <div class="col-xs-12 text-center">
        <?php
        echo GridView::widget([
            'dataProvider' => $dataProvider,
            'layout' => "{items}",
            'columns' => [
                [
                    'attribute' => 'begin',
                    'value' => function($model) {
                        /**
                         * @var RoadToCategory $model
                         */
                        return $model->getBeginString();
                    }
                ],
                [
                    'attribute' => 'end',
                    'value' => function($model) {
                        /**
                         * @var RoadToCategory $model
                         */
                        return $model->getEndString();
                    }
                ],
                'distance',
                [
                    'attribute' => 'road_category_id',
                    'value' => function($model) {
                        /**
                         * @var RoadToCategory $model
                         */
                        return $model->roadCategory->value;
                    }
                ],
            ]
        ])
        ?>
    </div>
</div>
