<?php

    /**
     * @var Road               $road
     * @var Region             $region
     * @var ActiveDataProvider $dataProvider
     */

    use common\models\FlowIntensity;
    use common\models\Region;
    use common\models\Road;
    use yii\data\ActiveDataProvider;
    use yii\grid\GridView;

    $this->title = $road->name;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Дороги',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $this->title,
        'url'   => [
            'view',
            'id' => $road->road_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Відомість інтенсивності руху та склад транспортного потоку - ' . ucfirst($region->name). ' область';
?>
<div class="site-index">
    <div class="col-xs-6 text-center">
        Міністрество транспорту України <br>
        Державна служба автомобільних доріг <br>
        України
    </div>
    <div class="col-xs-6 text-center">
        Служба автомобільних доріг у <?php echo $region->name; ?> області
    </div>
    <div class="clearfix"></div>
    <div class="col-xs-12 text-center">
        <p class="h3">Відомість</p>
        <p class="text-center"><b>інтенсивності руху та склад транспортного потоку</b></p>
        <p>на автомобільній дорозі</p>
        <p><ins><?php echo $road->name; ?></ins></p>
        <p><ins><?php echo $road->roadType->definition;?></ins> значення станом на <ins><?php echo date('d F Y');?> р.</ins></p>
    </div>
    <div class="col-xs-12 text-center">
        <?php
        echo GridView::widget([
            'dataProvider' => $dataProvider,
            'layout' => "{items}",
            'columns' => [
                [
                    'attribute' => 'location',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return $model->getLocationString();
                    }
                ],
                [
                    'attribute' => 'begin',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return $model->getBeginString();
                    }
                ],
                [
                    'attribute' => 'end',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return $model->getEndString();
                    }
                ],
                [
                    'attribute' => 'road_direction_id',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return $model->roadDirection->direction_name;
                    }
                ],
                [
                    'attribute' => 'settlement_id',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return $model->settlement->sign;
                    }
                ],
                'intensity_total',
                'intensity_increase',
                'intensity_moto',
                'intensity_moto_sidecar',
                'intensity_car',
                'intensity_truck_two',
                'intensity_truck_two_six',
                'intensity_truck_six_eight',
                'intensity_truck_eight_fourteen',
                'intensity_truck_fourteen',
                'intensity_lorry_twelve',
                'intensity_lorry_twelve_twenty',
                'intensity_lorry_twenty_thirty',
                'intensity_lorry_thirty',
                'intensity_tractor_under_ten',
                'intensity_tractor_over_ten',
                'intensity_bus',
                'intensity_bus_coupled',
                [
                    'attribute' => 'date_add',
                    'value' => function($model) {
                        /**
                         * @var FlowIntensity $model
                         */
                        return date('d.m.Y', $model->date_add);
                    }
                ],
            ],
        ]);
        ?>
    </div>
</div>
