<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\RoadWidth */

$this->title = $model->road_width_id;
$this->params['breadcrumbs'][] = ['label' => 'Road Widths', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-width-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->road_width_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->road_width_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'road_width_id',
            'region_id',
            'road_id',
            'begin',
            'end',
            'width_roadside_left',
            'width_reverse_road',
            'width_strip',
            'width_roadway_forward',
            'width_roadside_right',
            'count_lane_left',
            'count_lane_right',
        ],
    ]) ?>

</div>
