<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\RoadToCategory */

$this->title = $model->road_to_category_id;
$this->params['breadcrumbs'][] = ['label' => 'Road To Categories', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-to-category-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->road_to_category_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->road_to_category_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'road_to_category_id',
            'region_id',
            'road_id',
            'begin',
            'end',
            'distance',
            'road_category_id',
        ],
    ]) ?>

</div>
