<?php

    use common\models\RoadToCategory;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\RoadToCategorySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Категорії доріг';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-to-category-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Road To Category', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    /**
                     * @var RoadToCategory $model
                     */
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    /**
                     * @var RoadToCategory $model
                     */
                    return $model->road->name;
                }
            ],
            [
                'attribute' => 'begin',
                'value' => function($model) {
                    /**
                     * @var RoadToCategory $model
                     */
                    return $model->getBeginString();
                }
            ],
            [
                'attribute' => 'end',
                'value' => function($model) {
                    /**
                     * @var RoadToCategory $model
                     */
                    return $model->getEndString();
                }
            ],
            [
                'attribute' => 'road_category_id',
                'value' => function($model) {
                    /**
                     * @var RoadToCategory $model
                     */
                    return $model->roadCategory->value;
                }
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
