<?php

    use yii\helpers\Html;
    use yii\widgets\DetailView;

    /* @var $this yii\web\View */
    /* @var $model common\models\RoadService */

    $this->title = $model->getTitle();
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Обслуговування автодоріг',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="road-service-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Оновити', [
            'update',
            'id' => $model->road_service_id,
        ], [ 'class' => 'btn btn-primary' ]) ?>
        <?= Html::a('Видалити', [
            'delete',
            'id' => $model->road_service_id,
        ], [
            'class' => 'btn btn-danger',
            'data'  => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method'  => 'post',
            ],
        ]) ?>
    </p>

    <div class="statement_block">
        <div class="col-xs-6 text-center">
            Міністерство інфраструктури України<br>
            ДЕРЖАВНЕ АГЕНСТВО<br>
            АВТОМОБІЛЬНИХ ДОГІР УКРАЇНИ
        </div>
        <div class="col-xs-6">
            Служба автомобільних доріг у <?php echo $model->region->name; ?> області
        </div>
        <div class="clearfix"></div>
        <div class="col-xs-12 text-center">
            <p class="h3">Відомість</p>
            <p><b>обслуговування автодоріг</b></p>
            <p>на автомобільній дорозі</p>
            <p>
                <ins><?php echo $this->title; ?></ins>
            </p>
            <p>
                <ins><?php echo $model->road->roadType->definition; ?></ins>
                значення станом на
                <ins><b><?php echo date('d F Y'); ?></b> р.</ins>
            </p>
        </div>
        <div class="clearfix"></div>
        <div class="col-xs-12">
            <table align="center" class="table-bordered text-center statement-table">
                <tr>
                    <th colspan="2">Місцезнаходження, км+</th>
                    <th rowspan="2"><?php echo $model->getAttributeLabel('road_direction_id'); ?></th>
                    <th rowspan="2"><?php echo $model->getAttributeLabel('organization_id'); ?></th>
                    <th rowspan="2"><?php echo $model->getAttributeLabel('year_begin'); ?></th>
                </tr>
                <tr>
                    <th>Початок</th>
                    <th>кінець</th>
                </tr>
                <tr>
                    <th>1</th>
                    <th>2</th>
                    <th>3</th>
                    <th>4</th>
                    <th>5</th>
                </tr>
                <tr>
                    <td><?php echo $model->getBeginString(); ?></td>
                    <td><?php echo $model->getEndString(); ?></td>
                    <td><?php echo $model->roadDirection->direction_name; ?></td>
                    <td><?php echo $model->organization->name; ?></td>
                    <td><?php echo $model->year_begin; ?></td>
                </tr>
            </table>
        </div>
        <div class="clearfix"></div>
        <div class="col-xs-6" style="word-wrap: break-word">
            Склав <?php echo str_repeat('_', 50); echo date('Y'); ?> р.
        </div>
        <div class="col-xs-6">
            Начальник <?php echo str_repeat('_', 50); echo date('Y'); ?> р.
        </div>
        <div class="clearfix"></div>
    </div>

</div>
