<?php

    use common\models\RoadService;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\RoadServiceSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Обслуговування автодоріг';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-service-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Додати відомість', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => null,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    return $model->road->name;
                }
            ],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'begin',
                'value' => function($model) {
                    /**
                     * @var RoadService $model
                     */
                    return $model->getBeginString();
                }
            ],
            [
                'attribute' => 'end',
                'value' => function($model) {
                    /**
                     * @var RoadService $model
                     */
                    return $model->getEndString();
                }
            ],
            [
                'attribute' => 'road_direction_id',
                'value' => function($model) {
                    /**
                     * @var RoadService $model
                     */
                    return $model->roadDirection->direction_name;
                }
            ],
            [
                'attribute' => 'organization_id',
                'value' => function($model) {
                    /**
                     * @var RoadService $model
                     */
                    return $model->organization->name;
                }
            ],
            'year_begin',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
