<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View              $this
     * @var common\models\RoadService $model
     * @var array                     $roads
     * @var array                     $organizations
     * @var array                     $regions
     * @var array                     $directions
     * @var yii\widgets\ActiveForm    $form
     */
?>

<div class="road-service-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'begin')
             ->textInput() ?>

    <?= $form->field($model, 'end')
             ->textInput() ?>

    <?= $form->field($model, 'road_direction_id')
             ->dropDownList($directions) ?>

    <?= $form->field($model, 'organization_id')
             ->dropDownList($organizations) ?>

    <?= $form->field($model, 'year_begin')
             ->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Додати' : 'Оновити', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
