<?php
    use common\models\RoadPassport;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\data\ActiveDataProvider;
    use yii\web\View;
    use yii\widgets\ListView;

    /**
     * @var ActiveDataProvider $dataProvider
     * @var View               $this
     * @var integer            $passport_id
     * @var RoadPassport       $road_passport
     */
?>
<div class="col-xs-12">
    <div class="col-xs-2 col-sm-1">#</div>
    <div class="col-xs-2 col-sm-2">Км траси</div>
    <div class="col-xs-3">Довгота (lat)</div>
    <div class="col-xs-3">Широта (lng)</div>
    <div class="col-xs-1"></div>
    <div class="clearfix"></div>
    <?php
        $form = ActiveForm::begin([
            'id' => 'passport_form',
        ]);
        echo Html::activeHiddenInput($road_passport, 'road_passport_id');
        echo ListView::widget([
            'id'           => 'passport_control',
            'options'      => [
                'data' => [
                    'passport_id' => $passport_id,
                ],
            ],
            'itemOptions'  => [
                'class' => 'passport_point_item',
            ],
            'dataProvider' => $dataProvider,
            'itemView'     => '_point',
            'layout'       => '{items}',
            'showOnEmpty' => true,
        ]);
        echo Html::submitButton('Сохранить', [
            'class' => 'btn btn-success pull-right passport_submit',
        ]);
        $form->end();
    ?>
</div>
