<?php
    use common\models\Point;
    use yii\bootstrap\Html;

    /**
     * @var Point    $model
     * @var mixed    $key
     * @var integer  $index
     */
?>
<div>
    <div class="col-xs-2 col-sm-1 point_num">
        <?php
            echo Html::tag('span', $model->num, ['class' => 'point_num_value']);
            echo Html::activeHiddenInput($model, '['.$model->num.']num');
        ?>
    </div>
    <div class="col-xs-3 col-sm-2 point_km">
        <?php
            echo Html::activeTextInput($model, '['.$model->num.']km', ['class' => 'form-control km']);
        ?>
    </div>
    <div class="col-xs-3 point_lat">
        <?php
            echo Html::activeTextInput($model, '['.$model->num.']lat', ['class' => 'form-control latlng']);
        ?>
    </div>
    <div class="col-xs-3 point_lng">
        <?php
            echo Html::activeTextInput($model, '['.$model->num.']lng', ['class' => 'form-control latlng']);
        ?>
    </div>
    <div class="col-xs-1 point-menu">
        <a href="#pointControl<?php echo $model->num ?>" data-toggle="collapse" aria-expanded="false" aria-controls="pointControl<?php echo $model->num ?>">
            <span class="glyphicon glyphicon-menu-hamburger"></span>
        </a>
    </div>
    <div class="clearfix"></div>
</div>
<div class="collapse point_control" id="pointControl<?php echo $model->num ?>">
    <span class="glyphicon glyphicon-remove passport_point_remove control"></span>
    <span class="glyphicon glyphicon-plus passport_point_add control" title="Додати точку зверху"></span>
</div>
