<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\CrossSection */

$this->title = $model->cross_section_id;
$this->params['breadcrumbs'][] = ['label' => 'Cross Sections', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cross-section-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->cross_section_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->cross_section_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'cross_section_id',
            'region_id',
            'road_id',
            'location_left',
            'location_right',
            'direction',
            'surface_type_id',
            'length_section',
            'length_surface',
            'distance_edge',
            'width',
            'angle',
            'tube_availability',
            'safety_availability',
            'year_build',
            'year_repair',
            'state_common_id',
        ],
    ]) ?>

</div>
