<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View               $this
     * @var common\models\CrossSection $model
     * @var array                      $regions
     * @var array                      $roads
     * @var array                      $surface_types
     * @var array                      $state_commons
     * @var yii\widgets\ActiveForm $form
     */
?>

<div class="cross-section-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'region_id')->dropDownList($regions) ?>

    <?= $form->field($model, 'road_id')->dropDownList($roads) ?>

    <?= $form->field($model, 'location_left')->textInput() ?>

    <?= $form->field($model, 'location_right')->textInput() ?>

    <?= $form->field($model, 'direction')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'surface_type_id')->dropDownList($surface_types) ?>

    <?= $form->field($model, 'length_section')->textInput() ?>

    <?= $form->field($model, 'length_surface')->textInput() ?>

    <?= $form->field($model, 'distance_edge')->textInput() ?>

    <?= $form->field($model, 'width')->textInput() ?>

    <?= $form->field($model, 'angle')->textInput() ?>

    <?= $form->field($model, 'tube_availability')->dropDownList([0 => 'немає', 1 => 'є']) ?>

    <?= $form->field($model, 'safety_availability')->dropDownList([0 => 'немає', 1 => 'є']) ?>

    <?= $form->field($model, 'year_build')->textInput() ?>

    <?= $form->field($model, 'year_repair')->textInput() ?>

    <?= $form->field($model, 'state_common_id')->dropDownList($state_commons) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
