<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\BusStop */

$this->title = $model->bus_stop_id;
$this->params['breadcrumbs'][] = ['label' => 'Bus Stops', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="bus-stop-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->bus_stop_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->bus_stop_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'bus_stop_id',
            'road_id',
            'region_id',
            'settlement_id',
            'location_right',
            'location_left',
            'surface_type_id',
            'area_stop_availability',
            'area_land_availability',
            'pocket_availability',
            'toilet_availability',
            'year_build',
            'year_repair',
            'state_common_id',
        ],
    ]) ?>

</div>
