<?php

    namespace frontend\controllers;

    use common\models\DepartmentAffiliation;
    use common\models\Region;
    use common\models\Road;
    use common\models\ServiceObjectType;
    use common\models\Settlement;
    use Yii;
    use common\models\ServiceObject;
    use common\models\ServiceObjectSearch;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;

    /**
     * ServiceObjectController implements the CRUD actions for ServiceObject model.
     */
    class ServiceObjectController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }

        /**
         * Lists all ServiceObject models.
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new ServiceObjectSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel'  => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }

        /**
         * Displays a single ServiceObject model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }

        /**
         * Creates a new ServiceObject model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new ServiceObject();

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $service_object_types = ServiceObjectType::find()
                                                     ->select([
                                                         'name',
                                                         'service_object_type_id',
                                                     ])
                                                     ->asArray()
                                                     ->indexBy('service_object_type_id')
                                                     ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            $department_affiliations = DepartmentAffiliation::find()
                                                            ->select([
                                                                'name',
                                                                'department_affiliation_id',
                                                            ])
                                                            ->asArray()
                                                            ->indexBy('department_affiliation_id')
                                                            ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->service_object_id,
                ]);
            } else {
                return $this->render('create', [
                    'model'                   => $model,
                    'roads'                   => $roads,
                    'regions'                 => $regions,
                    'service_object_types'    => $service_object_types,
                    'settlements'             => $settlements,
                    'department_affiliations' => $department_affiliations,
                ]);
            }
        }

        /**
         * Updates an existing ServiceObject model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $service_object_types = ServiceObjectType::find()
                                                     ->select([
                                                         'name',
                                                         'service_object_type_id',
                                                     ])
                                                     ->asArray()
                                                     ->indexBy('service_object_type_id')
                                                     ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            $department_affiliations = DepartmentAffiliation::find()
                                                            ->select([
                                                                'name',
                                                                'department_affiliation_id',
                                                            ])
                                                            ->asArray()
                                                            ->indexBy('department_affiliation_id')
                                                            ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->service_object_id,
                ]);
            } else {
                return $this->render('update', [
                    'model'                   => $model,
                    'roads'                   => $roads,
                    'regions'                 => $regions,
                    'service_object_types'    => $service_object_types,
                    'settlements'             => $settlements,
                    'department_affiliations' => $department_affiliations,
                ]);
            }
        }

        /**
         * Deletes an existing ServiceObject model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();

            return $this->redirect([ 'index' ]);
        }

        /**
         * Finds the ServiceObject model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return ServiceObject the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if(( $model = ServiceObject::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
