<?php

namespace frontend\controllers;

use common\models\Region;
use common\models\Road;
use Yii;
use common\models\RoadWidth;
use common\models\RoadWidthSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * RoadWidthController implements the CRUD actions for RoadWidth model.
 */
class RoadWidthController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all RoadWidth models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RoadWidthSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single RoadWidth model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new RoadWidth model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new RoadWidth();
        $regions = Region::find()
            ->select([
                'name',
                'region_id',
            ])
            ->indexBy('region_id')
            ->asArray()
            ->column();
        $roads = Road::find()
            ->select([
                'name',
                'road_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->road_width_id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'regions' => $regions,
                'roads' => $roads,
            ]);
        }
    }

    /**
     * Updates an existing RoadWidth model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $regions = Region::find()
            ->select([
                'name',
                'region_id',
            ])
            ->indexBy('region_id')
            ->asArray()
            ->column();
        $roads = Road::find()
            ->select([
                'name',
                'road_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->road_width_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'regions' => $regions,
                'roads' => $roads,
            ]);
        }
    }

    /**
     * Deletes an existing RoadWidth model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the RoadWidth model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return RoadWidth the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = RoadWidth::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
