<?php
    namespace frontend\controllers;

    use common\models\Region;
    use common\models\Road;
    use common\models\RoadPassport;
    use yii\data\ActiveDataProvider;
    use yii\filters\VerbFilter;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;

    class RoadPassportController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'post' ],
                    ],
                ],
            ];
        }

        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }

        /**
         * @return mixed
         */
        public function actionCreate()
        {
            $roadpassport = new RoadPassport();
            $post = \Yii::$app->request->post();
            if($roadpassport->load($post) && $roadpassport->save()) {
                return $this->redirect([ 'index' ]);
            } else {
                $roads = Road::find()
                             ->select('name')
                             ->indexBy('road_id')
                             ->asArray()
                             ->column();
                $regions = Region::find()
                                 ->select('name')
                                 ->indexBy('region_id')
                                 ->asArray()
                                 ->column();
                return $this->render('create', [
                    'roadpassport' => $roadpassport,
                    'roads'        => $roads,
                    'regions'      => $regions,
                ]);
            }
        }

        /**
         * @param int $id
         *
         * @return mixed
         * @throws NotFoundHttpException
         */
        public function actionDelete(int $id)
        {
            $roadpassport = RoadPassport::findOne($id);
            if(empty( $roadpassport )) {
                throw new NotFoundHttpException('Road passport not found');
            }
            $roadpassport->delete();
            return $this->redirect([ 'index' ]);
        }

        /**
         * @return mixed
         */
        public function actionIndex()
        {
            $query = RoadPassport::find()
                         ->with('road', 'region');
            $dataProvider = new ActiveDataProvider([
                'query'      => $query,
                'pagination' => [
                    'pageSize' => 20,
                ],
            ]);
            return $this->render('index', [ 'dataProvider' => $dataProvider ]);
        }

        /**
         * @param int $id
         *
         * @return mixed
         * @throws NotFoundHttpException
         */
        public function actionUpdate(int $id)
        {
            $roadpassport = RoadPassport::findOne($id);
            if(empty( $roadpassport )) {
                throw new NotFoundHttpException('Road passport not found');
            }
            $post = \Yii::$app->request->post();
            if($roadpassport->load($post) && $roadpassport->save()) {
                return $this->redirect([ 'index' ]);
            } else {
                $roads = Road::find()
                             ->select('name')
                             ->indexBy('road_id')
                             ->asArray()
                             ->column();
                $regions = Region::find()
                                 ->select('name')
                                 ->indexBy('region_id')
                                 ->asArray()
                                 ->column();
                return $this->render('create', [
                    'roadpassport' => $roadpassport,
                    'roads'        => $roads,
                    'regions'      => $regions,
                ]);
            }
        }
    }
