<?php

    use yii\db\Migration;

    /**
     * Handles the creation for table `service_object`.
     */
    class m160712_144805_create_service_object extends Migration
    {

        /**
         * @inheritdoc
         */
        public function safeUp()
        {
            $this->createTable('service_object', [
                'service_object_id'         => $this->primaryKey()
                                                    ->comment('Індекс'),
                'road_id'                   => $this->integer()
                                                    ->comment('Дорога'),
                'region_id'                 => $this->integer()
                                                    ->comment('Область'),
                'service_object_type_id'    => $this->integer()
                                                    ->comment('Вид споруди чи об\'єкту'),
                'settlement_id'             => $this->integer()
                                                    ->comment('Назва підприємства та населеного пункту'),
                'department_affiliation_id' => $this->integer()
                                                    ->comment('Відоча приналежність'),
                'location_right'            => $this->float()
                                                    ->comment('Місцезнаходження, км+ справа'),
                'location_left'             => $this->float()
                                                    ->comment('Місцезнаходження, км+ зліва'),
                'location_axis'             => $this->float()
                                                    ->comment('Місцезнаходження, км+ по осі'),
                'distance'                  => $this->float()
                                                    ->comment('Відстань до об\'єкту від вісі дор., м'),
                'capacity'                  => $this->float()
                                                    ->comment('Потужність'),
                'arrangement_elements'      => $this->text()
                                                    ->comment('Елементи облаштування'),
            ]);
            $this->createTable('service_object_type', [
                'service_object_type_id' => $this->primaryKey(),
                'name'                   => $this->string(),
            ]);
            $this->createTable('department_affiliation', [
                'department_affiliation_id' => $this->primaryKey(),
                'name'                      => $this->string(),
            ]);
            $this->batchInsert('service_object_type', [ 'name' ], [
                [ 'кафе' ],
                [ 'автозаправочна станція (АЗС)' ],
                [ 'мотель' ],
            ]);
            $this->batchInsert('department_affiliation', [ 'name' ], [
                [ 'Приватне підприємство' ],
            ]);
            $this->addForeignKey('service_object_road', 'service_object', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('service_object_region', 'service_object', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('service_object_settlement', 'service_object', 'settlement_id', 'settlement', 'settlement_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('service_object_department_affiliation', 'service_object', 'department_affiliation_id', 'department_affiliation', 'department_affiliation_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('service_object_service_object_type', 'service_object', 'service_object_type_id', 'service_object_type', 'service_object_type_id', 'CASCADE', 'CASCADE');
        }

        /**
         * @inheritdoc
         */
        public function safeDown()
        {
            $this->dropForeignKey('service_object_road', 'service_object');
            $this->dropForeignKey('service_object_region', 'service_object');
            $this->dropForeignKey('service_object_settlement', 'service_object');
            $this->dropForeignKey('service_object_department_affiliation', 'service_object');
            $this->dropForeignKey('service_object_service_object_type', 'service_object');
            $this->dropTable('service_object');
            $this->dropTable('service_object_type');
            $this->dropTable('department_affiliation');
        }
    }
