<?php

    use yii\db\Migration;

    /**
     * Handles the creation for table `cross_section`.
     */
    class m160712_110146_create_cross_section extends Migration
    {

        /**
         * @inheritdoc
         */
        public function safeUp()
        {
            $this->createTable('cross_section', [
                'cross_section_id'    => $this->primaryKey()
                                              ->comment('Індекс'),
                'region_id'           => $this->integer()
                                              ->comment('Область'),
                'road_id'             => $this->integer()
                                              ->comment('Дорога'),
                'location_left'       => $this->float()
                                              ->comment('Місцеположення, км+ справа'),
                'location_right'      => $this->float()
                                              ->comment('Місцеположення, км+ зліва'),
                'direction'           => $this->string()
                                              ->comment('Напрямок з\'їзду'),
                'surface_type_id'     => $this->integer()
                                              ->comment('Тип покриття'),
                'length_section'      => $this->float()
                                              ->comment('Фактична довжина, м з\'їзду'),
                'length_surface'      => $this->float()
                                              ->comment('Фактична довжина, м покриття'),
                'distance_edge'       => $this->float()
                                              ->comment('Відстань від крайки проїзної частики, м'),
                'width'               => $this->float()
                                              ->comment('Ширина, м'),
                'angle'               => $this->float()
                                              ->comment('Кут примикання'),
                'tube_availability'   => $this->integer()
                                              ->comment('Наявність облаштування, труба'),
                'safety_availability' => $this->integer()
                                              ->comment('Наявність облаштування, острівок безпеки'),
                'year_build'          => $this->integer()
                                              ->comment('Рік спорудження'),
                'year_repair'         => $this->integer()
                                              ->comment('Рік ремонту'),
                'state_common_id'     => $this->integer()
                                              ->comment('Технічний стан'),
            ]);
            $this->addForeignKey('cross_section_region', 'cross_section', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('cross_section_road', 'cross_section', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('cross_section_surface_type', 'cross_section', 'surface_type_id', 'surface_type', 'surface_type_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('cross_section_state_common', 'cross_section', 'state_common_id', 'state_common', 'state_common_id', 'CASCADE', 'CASCADE');
        }

        /**
         * @inheritdoc
         */
        public function safeDown()
        {
            $this->dropForeignKey('cross_section_region', 'cross_section');
            $this->dropForeignKey('cross_section_road', 'cross_section');
            $this->dropForeignKey('cross_section_surface_type', 'cross_section');
            $this->dropForeignKey('cross_section_state_common', 'cross_section');
            $this->dropTable('cross_section');
        }
    }
