<?php

    use yii\db\Migration;

    class m160711_150500_flow_intensity extends Migration
    {

        public function safeUp()
        {
            $this->createTable('flow_intensity', [
                'flow_intensity_id'              => $this->primaryKey()
                                                         ->comment('Індекс'),
                'road_id'                        => $this->integer()
                                                         ->comment('Автомобільна дорога'),
                'region_id'                      => $this->integer()
                                                         ->comment('Область'),
                'location'                       => $this->float()
                                                         ->comment('Місцезнаходження, км+'),
                'begin'                          => $this->float()
                                                         ->comment('Місцезнаходження ділянки з однорідною інтенсивністю руху, км+, початок'),
                'end'                            => $this->float()
                                                         ->comment('Місцезнаходження ділянки з однорідною інтенсивністю руху, км+, кінець'),
                'road_direction_id'              => $this->integer()
                                                         ->comment('Напрямок смуги руху'),
                'settlement_id'                  => $this->integer()
                                                         ->comment('Найближчий населений пункт'),
                'intensity_total'                => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, всього'),
                'intensity_increase'             => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, приріст'),
                'intensity_moto'                 => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, мотоцикл без коляски та мопед'),
                'intensity_moto_sidecar'         => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, мотоцикл з коляскою'),
                'intensity_car'                  => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, легковий автомобіль'),
                'intensity_truck_two'            => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: до 2 т.'),
                'intensity_truck_two_six'        => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 2 т. до 6 т.'),
                'intensity_truck_six_eight'      => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 6 т. до 8 т.'),
                'intensity_truck_eight_fourteen' => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: від 8 т. до 14 т.'),
                'intensity_truck_fourteen'       => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, вантажний автомобіль вантажопідйомністю: понад 14 т.'),
                'intensity_lorry_twelve'         => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: до 12 т.'),
                'intensity_lorry_twelve_twenty'  => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: від 12 т. до 20 т.'),
                'intensity_lorry_twenty_thirty'  => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: від 20 т. до 30 т.'),
                'intensity_lorry_thirty'         => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автопоїзд вантажопідйомністю: понад 30 т.'),
                'intensity_tractor_under_ten'    => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, колісний трактор з причепами до 10 т.'),
                'intensity_tractor_over_ten'     => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, колісний трактор з причепами понад 10 т.'),
                'intensity_bus'                  => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автобус, тролейбус'),
                'intensity_bus_coupled'          => $this->integer()
                                                         ->comment('Інтенсивність руху, авт/добу, автобус зчеплений (здвоєний)'),
                'date_add'                       => $this->integer()
                                                         ->comment('Дата визначення'),
            ]);
            $this->addCommentOnTable('flow_intensity', 'Відомість інтенсивності руху та склад транспортного потоку');
            $this->addForeignKey('flow_intensity_road', 'flow_intensity', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('flow_intensity_region', 'flow_intensity', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('flow_intensity_road_direction', 'flow_intensity', 'road_direction_id', 'road_direction', 'road_direction_id', 'CASCADE', 'CASCADE');
            $this->addForeignKey('flow_intensity_settlement', 'flow_intensity', 'settlement_id', 'settlement', 'settlement_id', 'CASCADE', 'CASCADE');
        }

        public function safeDown()
        {
            $this->dropForeignKey('flow_intensity_road', 'flow_intensity');
            $this->dropForeignKey('flow_intensity_region', 'flow_intensity');
            $this->dropForeignKey('flow_intensity_road_direction', 'flow_intensity');
            $this->dropForeignKey('flow_intensity_settlement', 'flow_intensity');
            $this->dropTable('flow_intensity');
        }
    }
