<?php

use yii\db\Migration;

class m160609_074818_tables extends Migration
{
    public function safeUp()
    {
        // Table 5.1
        $this->createTable('road', [
            'road_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'value' => $this->text()->comment('Значення'),
            'length' => $this->float()->comment('Загальна довжина'),
            'historical_background' => $this->text()->comment('Історична довідка'),
            'economic_value' => $this->text()->comment('Господарське значення'),
            'law_doc' => $this->string()->comment('Правовстановлюючий документ титулу (pdf [3], [5])'),
            'accept_transfer_doc' => $this->string()->comment('Правовстановлюючий документ про приймання-передачу титулу на баланс (pdf [3])'),
            'acceptance_doc' => $this->string()->comment('Документ про прийняття в експлуатацію (pdf [3], [15])'),
            'authority_act' => $this->string()->comment('Звіт органа управління (форма No1-ДГ [6])'),
            'road_type_id' => $this->integer()->comment('Тип дороги'),
        ]);
        $this->addCommentOnTable('road', 'Облікова відомість титулів автомобільних доріг');
    
        // Table 5.2
        $this->createTable('authority', [
            'authority_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'authority_name' => $this->string()->comment('Назва органу управління (балансоутримувача) ([4])'),
            'info' => $this->text()->comment('Реквізити та інформація про орган управління'),
            'road_section_number' => $this->integer()->comment('Номер ділянки дороги'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах)'),
            'right_coords' => $this->string()->comment('Координати вісі правого проїзду (згідно 6.2.2 СОУ 42.1-37641918-122; геодані з двома цифрами після коми)'),
            'begin_scheme' => $this->string()->comment('Схема початку/межі збірного об’єкту (ділянки, титулу) (tiff [3])'),
            'end_scheme' => $this->string()->comment('Схема кінця/межі збірного об’єкту (ділянки, титулу) (tiff [3])'),
        ]);
        $this->addCommentOnTable('authority', 'Облікова відомість органів управління');
    
        // Table 5.3
        $this->createTable('contractor', [
            'contractor_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'contractor_name' => $this->string()->comment('Назва підрядника'),
            'info' => $this->text()->comment('Реквізити та інформація про підрядника'),
            'road_section_number' => $this->integer()->comment('Номер ділянки дороги'),
            'contractor_section_number' => $this->integer()->comment('Номер ділянки підрядника'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах)'),
            'right_coords' => $this->string()->comment('Координати вісі правого проїзду (згідно 6.2.2 СОУ 42.1-37641918-122; геодані з двома цифрами після коми)'),
            'begin_scheme' => $this->string()->comment('Схема початку/межі збірного об’єкту (ділянки, титулу) (tiff [3])'),
            'end_scheme' => $this->string()->comment('Схема кінця/межі збірного об’єкту (ділянки, титулу) (tiff [3])'),
        ]);
        $this->addCommentOnTable('contractor', 'Облікова відомість підрядників з експлуатаційного утримання');
    
        // Table 5.4
        $this->createTable('digital_model', [
            'digital_model_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'cross_profile_number' => $this->integer()->comment('Номер поперечного профілю'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'cross_profile_position' => $this->string()->comment('Положення поперечного профілю (псевдогеодані)'),
            'right_coords' => $this->string()->comment('Координати вісі правого проїзду в прямому напрямку руху (згідно 6.2.2 СОУ 42.1-37641918-122; геодані з двома цифрами після коми)'),
            'land_mark' => $this->string()->comment('Відмітка землі під віссю правого проїзду в прямому напрямку руху (геодані з двома цифрами після коми)'),
            'bearing_coords' => $this->string()->comment('Координати опорних точок (геодані з двома цифрами після коми)'),
        ]);
        $this->addCommentOnTable('digital_model', 'Дані про цифрову модель автомобільної дороги та рельєф навколишньої місцевості');
    
        // Table 5.6
        $this->createTable('row', [
            'row_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах)'),
            'land_cadastral_number' => $this->text()->comment('Кадастровий номер земельної ділянки'),
            'area' => $this->float()->comment('Площа земельної ділянки (у квадратних метрах; з двома цифрами після коми)'),
            'cost_standard' => $this->float()->comment('Нормативна грошова оцінка земельної ділянки (тис.грн)'),
            'cost_yearly' => $this->float()->comment('Щорічні витрати на право землекористування (тис.грн)'),
            'cost_balance' => $this->float()->comment('Балансова вартість земельної ділянки (тис.грн)'),
            'outline_coords' => $this->string()->comment('Координати контуру (геодані)'),
        ]);
        $this->addCommentOnTable('row', 'Дані про смугу відведення');
    
        // Table 5.7
        $this->createTable('roadway', [
            'roadway_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'cross_profile_position' => $this->string()->comment('Положення поперечного профілю (псевдогеодані)'),
            'road_category_id' => $this->integer()->comment('Категорія дороги (ДБН В.2.3-4, [4])'),
            'lane_width_standard' => $this->float()->comment('Нормативна ширина смуги руху (згідно табл. 5.1 ДБН В.2.3-4)'),
            'lane_count_forward' => $this->integer()->comment('Кількість смуг руху в прямому напрямку руху'),
            'lane_count_back' => $this->integer()->comment('Кількість смуг руху в зворотному напрямку руху'),
            'slope_cross_left' => $this->integer()->comment('Поперечний похил ліворуч'),
            'slope_cross_right' => $this->integer()->comment('Поперечний похил праворуч'),
            'surface_width_total' => $this->float()->comment('Загальна ширина покриття (у метрах; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'surface_area' => $this->float()->comment('Площа покриття (у квадратних метрах; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'roadside_fortified_width_left' => $this->float()->comment('Ширина укріпленої смуги узбіччя ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'pocket_width_left' => $this->float()->comment('Ширина заїзної кишені ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'border_height_left' => $this->float()->comment('Висота бордюру ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'speed_lane_outer_width_left' => $this->float()->comment('Ширина зовнішньої ПШС ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'main_lane_width_left' => $this->float()->comment('Ширина основних смуг руху ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'speed_lane_inner_width_left' => $this->float()->comment('Ширина внутрішньої ПШС ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_fortified_width_left' => $this->float()->comment('Ширина укріпленої смуги розділювальної смуги ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_border_height_left' => $this->float()->comment('Висота бордюру розділювальної смуги ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_roadside_width_left' => $this->float()->comment('Ширина узбіччя розділювальної смуги ліворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_up_width' => $this->float()->comment('Ширина розділювальної смуги по верху (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_bottom_width' => $this->float()->comment('Ширина розділювальної смуги по низу (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_depth' => $this->float()->comment('Глибина розділювальної смуги (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_border_height_right' => $this->float()->comment('Висота бордюру розділювальної смуги праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_roadside_width_right' => $this->float()->comment('Ширина узбіччя розділювальної смуги праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'divide_lane_fortified_width_right' => $this->float()->comment('Ширина укріпленої смуги розділювальної смуги праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'speed_lane_inner_width_right' => $this->float()->comment('Ширина внутрішньої ПШС праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'main_lane_width_right' => $this->float()->comment('Ширина основних смуг руху праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'speed_lane_outer_width_right' => $this->float()->comment('Ширина зовнішньої ПШС праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'roadside_fortified_width_right' => $this->float()->comment('Ширина укріпленої смуги узбіччя праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'pocket_width_right' => $this->float()->comment('Ширина заїзної кишені праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
            'border_height_right' => $this->float()->comment('Висота бордюру праворуч (у метрах; з двома цифрами після коми ; розраховується автоматично на підставі даних згідно табл. 5.4)'),
        ]);
        $this->addCommentOnTable('roadway', 'Дані про проїзну частину');
    
        // Table 5.8
        $this->createTable('horizontal_curve_radius', [
            'horizontal_curve_radius_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок кривої (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець кривої (псевдогеодані)'),
            'begin_x' => $this->float()->comment('Координата Х початку кривої'),
            'begin_y' => $this->float()->comment('Координата Y початку кривої'),
            'end_x' => $this->float()->comment('Координата Х кінця кривої'),
            'end_y' => $this->float()->comment('Координата Y кінця кривої'),
            'radius' => $this->integer()->comment('Радіус (у метрах)'),
            'angle' => $this->float()->comment('Кут (в градусах; з двома цифрами після коми)'),
            'curve_direction' => $this->string()->comment('Напрямок кривої'),
            'move_direction' => $this->string()->comment('Напрямок руху'),
        ]);
        $this->addCommentOnTable('horizontal_curve_radius', 'Дані про радіуси горизонтальних кривих');
        
        // Table 5.9
        $this->createTable('road_surface', [
            'road_surface_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_id' => $this->integer()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'region_id' => $this->integer()->comment('Область'),
            'road_direction_id' => $this->integer()->comment('Напрямок смуги руху'),
            'surface_type_id' => $this->integer()->comment('Тип покриття'),
            'surface_treatment_id' => $this->integer()->comment('Тип поверхневої обробки'),
            'state_common_id' => $this->integer()->comment('Стан покриття'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->float()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->float()->comment('Кінець ділянки (псевдогеодані)'),
            'lane_count_left' => $this->integer()->comment('Кількість смуг руху ліворуч'),
            'lane_count_right' => $this->integer()->comment('Кількість смуг руху праворуч'),
            'road_surface_construction_id' => $this->string()->comment('Конструкція дорожнього одягу (окрема облікова картка; табл. 5.10)'),
            'elastisity_module' => $this->float()->comment('Фактичний модуль пружності (згідно з [9]; з двома цифрами після коми)'),
        ]);
        $this->addCommentOnTable('road_surface', 'Дані про дорожній одяг');

        // Table 5.10
        $this->createTable('structural_layers', [
            'structural_layers_id' => $this->primaryKey()->comment('згідно з [4]'),
            'layer_number' => $this->integer()->comment('Номер шару'),
            'material_code' => $this->integer()->comment('Код матеріалу (згідно з [4])'),
            'layer_width' => $this->float()->comment('Товщина шару (в сантиметрах)'),
            'strength_coef' => $this->float()->comment('Коефіцієнт впливу міцності складових шару К МЦ (згідно з [17]; з двома цифрами після коми)'),
            'viscosity_coef' => $this->float()->comment('Коефіцієнт впливу в\'яжучого К В (згідно з [17]; з двома цифрами після коми)'),
            'technology_coef' => $this->float()->comment('Коефіцієнт впливу якості технології К Т (згідно з [17]; з двома цифрами після коми)'),
            'conditions_coef' => $this->float()->comment('Коефіцієнт впливу умов служби К С (згідно з [17]; з двома цифрами після коми)'),
            'land_soil' => $this->string()->comment('Ґрунт земляного полотна (згідно з [4])'),
            'elastisity_module' => $this->float()->comment('Модуль пружності (згідно з [9]; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('structural_layers', 'Дані про конструктивні шари дорожнього одягу');

        // Table 5.11
        $this->createTable('road_surface_strenght', [
            'road_surface_strenght_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin_section' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end_section' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'lane_count_left' => $this->integer()->comment('Кількість смуг руху ліворуч'),
            'lane_count_right' => $this->integer()->comment('Кількість смуг руху праворуч'),
            'elastisity_module' => $this->float()->comment('Фактичний модуль пружності (згідно з [9]; з двома цифрами після коми)'),
            'elastisity_module_calc' => $this->float()->comment('Розрахунковий модуль пружності (згідно з [9]; з двома цифрами після коми)'),
            'safety_margin_coef' => $this->float()->comment('Коефіцієнт запасу міцності (згідно з [9]; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('road_surface_strenght', 'Дані про міцність дорожнього одягу');

        // Table 5.12
        $this->createTable('road_surface_flatness', [
            'road_surface_flatness_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin_section' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end_section' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'lane_count_left' => $this->integer()->comment('Кількість смуг руху ліворуч'),
            'lane_count_right' => $this->integer()->comment('Кількість смуг руху праворуч'),
            'forward_lanes_iri' => $this->float()->comment('Показник IRI смуг прямого напрямку руху (згідно з [9]; з двома цифрами після коми)'),
            'back_lanes_iri' => $this->float()->comment('Показник IRI смуг зворотного напрямку руху (згідно з [9]; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('road_surface_flatness', 'Дані про рівність покриття');

        // Table 5.13
        $this->createTable('road_surface_clutch', [
            'road_surface_clutch_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin_section' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end_section' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'lane_count_left' => $this->integer()->comment('Кількість смуг руху ліворуч'),
            'lane_count_right' => $this->integer()->comment('Кількість смуг руху праворуч'),
            'forward_lanes_hollow' => $this->float()->comment('Середня величина заглиблень шорсткості (h свр )смуг прямого напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'forward_lanes_density' => $this->float()->comment('Середня щільність виступів шорсткості (і n ) смуг прямого напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'forward_lanes_ledge' => $this->float()->comment('Середній радіус виступів шорсткості (R свр ) смуг прямого напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'back_lanes_hollow' => $this->float()->comment('Середня величина заглиблень шорсткості (h свр )смуг зворотнього напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'back_lanes_density' => $this->float()->comment('Середня щільність виступів шорсткості (і n ) смуг зворотнього напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'back_lanes_ledge' => $this->float()->comment('Середній радіус виступів шорсткості (R свр ) смуг зворотнього напрямку руху (згідно з [18]; з двома цифрами після коми)'),
            'clutch_coef' => $this->float()->comment('Фактичне значення коефіцієнта зчеплення (згідно з [18]; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('road_surface_clutch', 'Дані про зчіпні якості');

        // Table 5.14
        $this->createTable('road_surface_damage', [
            'road_surface_damage_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin_section' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end_section' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'lane_count_left' => $this->integer()->comment('Кількість смуг руху ліворуч'),
            'lane_count_right' => $this->integer()->comment('Кількість смуг руху праворуч'),
            'back_lane_number' => $this->integer()->comment('Номер смуги зворотного напрямку руху'),
            'forward_lane_number' => $this->integer()->comment('Номер смуги прмямого напрямку руху'),
            'state_indicator' => $this->integer()->comment('Показник стану (табл. Б.2 СОУ 42.1-37641918-122)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('road_surface_damage', 'Дані про пошкодження дорожнього одягу');

        // Table 5.15
        $this->createTable('roadbed_size', [
            'roadbed_size_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'cross_profile_position' => $this->string()->comment('Положення поперечного профілю (псевдогеодані)'),
            'road_category_id' => $this->integer()->comment('Категорія дороги (згідно з [4])'),
            'mound_left' => $this->float()->comment('Насип (виїмка) ліворуч (у метрах; з двома цифрами після коми)'),
            'mound_right' => $this->float()->comment('Насип (виїмка) праворуч (у метрах; з двома цифрами після коми)'),
            'mound_avarage_size' => $this->float()->comment('Середня величина насипу (виїмки) (у метрах; з двома цифрами після коми)'),
            'berm_third_width_left' => $this->float()->comment('Ширина 3-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_third_height_left' => $this->float()->comment('Висота 3-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_third_slope_left' => $this->float()->comment('Закладання укосу 3-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_width_left' => $this->float()->comment('Ширина 2-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_height_left' => $this->float()->comment('Висота 2-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_slope_left' => $this->float()->comment('Закладання укосу 2-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_width_left' => $this->float()->comment('Ширина 1-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_height_left' => $this->float()->comment('Висота 1-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_slope_left' => $this->float()->comment('Закладання укосу 1-ї берми ліворуч (у метрах; з двома цифрами після коми)'),
            'ditch_top_width_left' => $this->float()->comment('Ширина по верху кювету (кювету-резерву) ліворуч (у метрах; з двома цифрами після коми)'),
            'ditch_bottom_width_left' => $this->float()->comment('Ширина по низу кювету (кювету-резерву) ліворуч (у метрах; з двома цифрами після коми)'),
            'ditch_depth_left' => $this->float()->comment('Глибина кювету (кювету-резерву) ліворуч (у метрах; з двома цифрами після коми)'),
            'roadside_width_left' => $this->float()->comment('Ширина узбіччя ліворуч (у метрах; з двома цифрами після коми)'),
            'roadside_width_right' => $this->float()->comment('Ширина узбіччя праворуч (у метрах; з двома цифрами після коми)'),
            'ditch_top_width_right' => $this->float()->comment('Ширина по верху кювету (кювету-резерву) праворуч (у метрах; з двома цифрами після коми)'),
            'ditch_bottom_width_right' => $this->float()->comment('Ширина по низу кювету (кювету-резерву) праворуч (у метрах; з двома цифрами після коми)'),
            'ditch_depth_right' => $this->float()->comment('Глибина кювету (кювету-резерву) праворуч (у метрах; з двома цифрами після коми)'),
            'berm_third_width_right' => $this->float()->comment('Ширина 3-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_third_height_right' => $this->float()->comment('Висота 3-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_third_slope_right' => $this->float()->comment('Закладання укосу 3-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_width_right' => $this->float()->comment('Ширина 2-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_height_right' => $this->float()->comment('Висота 2-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_second_slope_right' => $this->float()->comment('Закладання укосу 2-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_width_right' => $this->float()->comment('Ширина 1-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_height_right' => $this->float()->comment('Висота 1-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'berm_first_slope_right' => $this->float()->comment('Закладання укосу 1-ї берми праворуч (у метрах; з двома цифрами після коми)'),
            'road_surface_width' => $this->float()->comment('Ширина земляного полотна поверху (у метрах; з двома цифрами після коми)'),
            'road_surface_capacity' => $this->float()->comment('Об\'єм земляного полотна (у кубічних метрах; з двома цифрами після коми)'),
            'land_soil' => $this->string()->comment('Ґрунт земляного полотна (згідно з [4])'),
        ]);
        $this->addCommentOnTable('roadbed_size', 'Дані про геометричні розміри земляного полотна');

        // Table 5.16
        $this->createTable('rally', [
            'rally_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'position_according_road' => $this->text()->comment('Розташування відносно дороги (текст)'),
            'direction' => $this->text()->comment('Напрямок (текст)'),
            'fortified_length' => $this->float()->comment('Довжина укріплення (у метрах; з двома цифрами після коми)'),
            'layer_material_top_id' => $this->integer()->comment('Матеріал верхнього шару покриття (згідно табл. 8.1 ДБН В.2.3-4)'),
            'surface_area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'road_surface_capacity' => $this->float()->comment('Об\'єм земляного полотна (у кубічних метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'rally_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.17)'),
        ]);
        $this->addCommentOnTable('rally', 'Облікова відомість з\'їздів та виїздів');

        // Table 5.17
        $this->createTable('rally_card', [
            'rally_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'position_according_road' => $this->text()->comment('Розташування відносно дороги (текст)'),
            'direction' => $this->text()->comment('Напрямок (текст)'),
            'junction_angle' => $this->float()->comment('Кут примикання (в градусах; з двома цифрами після коми)'),
            'junction_rally_radius' => $this->float()->comment('Радіус спряження з\'їзду (у метрах; з двома цифрами після коми)'),
            'junction_exit_radius' => $this->float()->comment('Радіус спряження виїзду (у метрах; з двома цифрами після коми)'),
            'fortified_length' => $this->float()->comment('Довжина укріплення (у метрах; з двома цифрами після коми)'),
            'layer_material_top_id' => $this->integer()->comment('Матеріал верхнього шару покриття (згідно табл. 8.1 ДБН В.2.3-4)'),
            'mound_rally_begin' => $this->float()->comment('Насип (виїмка) на початку з\'їзду або виїзду (у метрах; з двома цифрами після коми)'),
            'mound_rally_end' => $this->float()->comment('Насип (виїмка) в кінці з\'їзду або виїзду (у метрах; з двома цифрами після коми)'),
            'surface_area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'road_surface_capacity' => $this->float()->comment('Об\'єм земляного полотна (у кубічних метрах; з двома цифрами після коми)'),
            'vector_direction_x1' => $this->float()->comment('Координата х 1 вектору напрямку з’їзду або виїзду (з двома цифрами після коми)'),
            'vector_direction_x2' => $this->float()->comment('Координата х 2 вектору напрямку з’їзду або виїзду (з двома цифрами після коми)'),
            'vector_direction_y1' => $this->float()->comment('Координата y 1 вектору напрямку з’їзду або виїзду (з двома цифрами після коми)'),
            'vector_direction_y2' => $this->float()->comment('Координата y 2 вектору напрямку з’їзду або виїзду (з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'state_indicator' => $this->integer()->comment('Показник стану (табл. Б.2 СОУ 42.1-37641918-122)'),
            'fortified_coords' => $this->string()->comment('Координати укріплення та/або покриття (геодані)'),
            'road_surface_top_coords' => $this->string()->comment('Координати верху земляного полотна (геодані)'),
            'road_surface_bottom_coords' => $this->string()->comment('Координати низу земляного полотна (геодані)'),
        ]);
        $this->addCommentOnTable('rally_card', 'Дані про з\'їзд або виїзд');

        // Table 5.18
        $this->createTable('tunnel', [
            'tunnel_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'center_position' => $this->string()->comment('Положення середини тунелю (псевдогеодані)'),
            'construction_length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'cross_scheme' => $this->float()->comment('Поперечна схема (у метрах; з двома цифрами після коми)'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'height' => $this->float()->comment('Габарит по висоті (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Габарит по ширині (у метрах; з двома цифрами після коми)'),
            'sideway_width_left' => $this->float()->comment('Ширина тротуару ліворуч (у метрах; з двома цифрами після коми)'),
            'sideway_width_right' => $this->float()->comment('Ширина тротуару праворуч (у метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'tunnel_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.19)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('rally', 'Облікова відомість з\'їздів та виїздів');

        // Table 5.19
        $this->createTable('tunnel_card', [
            'tunnel_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'center_position' => $this->string()->comment('Положення середини споруди (псевдогеодані)'),
            'movement_direction' => $this->integer()->comment('Напрямок руху, що забезпечує споруда (згідно з [4])'),
            'nearest_settlement_name' => $this->text()->comment('Назва найближчого населеного пункту'),
            'nearest_settlement_distance' => $this->float()->comment('Відстань до найближчого населеного пункту (в кілометрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Технічний стан (згідно з [4])'),
            'lane_count_forward' => $this->integer()->comment('Кількість смуг руху в прямому напрямку руху'),
            'lane_count_back' => $this->integer()->comment('Кількість смуг руху праворуч в зворотному напрямку руху'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'sideway_width_forward_left' => $this->float()->comment('Ширина тротуару ліворуч від прямого напрямку руху (у метрах; з двома цифрами після коми)'),
            'sideway_width_forward_right' => $this->float()->comment('Ширина тротуару праворуч від прямого напрямку руху (у метрах; з двома цифрами після коми)'),
            'bearing_structures_long_scheme' => $this->text()->comment('Поздовжня схема несучих конструкцій по ходу кілометражу'),
            'slope_long_scheme' => $this->text()->comment('Поздовжня схема похилів'),
            'drainage_tray_internal_type' => $this->integer()->comment('Тип лотків внутрішнього водовідведення (згідно з [4])'),
            'drainage_tray_internal_length' => $this->float()->comment('Загальна довжина лотків внутрішнього водовідведення (у метрах; з двома цифрами після коми)'),
            'drainage_tunnel_internal_type' => $this->integer()->comment('Тип дренажних штолень внутрішнього водовідведення (згідно з [4])'),
            'drainage_tunnel_internal_length' => $this->float()->comment('Загальна довжина дренажних штолень внутрішнього водовідведення (у метрах; з двома цифрами після коми)'),
            'drainage_other_internal_construction' => $this->integer()->comment('Наявність інших внутрішніх водовідвідних споруд (згідно з [4])'),
            'drainage_tray_outer_type' => $this->integer()->comment('Тип лотків поверхневого водовідведення (згідно з [4])'),
            'drainage_tray_outer_length' => $this->float()->comment('Загальна довжина лотків поверхневого водовідведення (у метрах; з двома цифрами після коми)'),
            'drainage_tunnel_outer_type' => $this->integer()->comment('Тип нагірних канав поверхневого водовідведення (згідно з [4])'),
            'drainage_tunnel_outer_length' => $this->float()->comment('Загальна довжина нагірних канав поверхневого водовідведення (у метрах; з двома цифрами після коми)'),
            'drainage_other_outer_construction' => $this->integer()->comment('Наявність інших поверхневих водовідвідних споруд (згідно з [4])'),
            'fence_height' => $this->float()->comment('Висота огородження (у метрах; з двома цифрами після коми)'),
            'sidewalk_type_left' => $this->integer()->comment('Тип тротуару ліворуч (згідно з [4])'),
            'barrier_material_type_left' => $this->integer()->comment('Матеріал перил тротуару ліворуч (згідно з [4])'),
            'barrier_height_left' => $this->integer()->comment('Висота перил тротуару ліворуч (у метрах; з двома цифрами після коми)'),
            'sidewalk_type_right' => $this->integer()->comment('Тип тротуару праворуч (згідно з [4])'),
            'barrier_material_type_right' => $this->integer()->comment('Матеріал перил тротуару праворуч (згідно з [4])'),
            'barrier_height_right' => $this->integer()->comment('Висота перил тротуару праворуч (у метрах; з двома цифрами після коми)'),
            'roadway_material_id' => $this->integer()->comment('Матеріал покриття проїзної частини (згідно табл. 8.1 ДБН В.2.3-4)'),
            'ventilation_type_id' => $this->integer()->comment('Тип вентиляції (згідно з [4])'),
            'light_type_id' => $this->integer()->comment('Тип освітлення (згідно з [4])'),
            'antiseismic_type_id' => $this->integer()->comment('Типи антисейсмічних пристроїв (згідно з [4])'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'security_connection_availability' => $this->integer()->comment('Наявність охорони та зв\'язку (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'tunnel_portal_card_id' => $this->integer()->comment('Оголовки (окрема облікова картка; табл. 5.20)'),
            'tunnel_body_card_id' => $this->integer()->comment('Тіло тунелю (окрема облікова картка; табл. 5.21)'),
            'sewage_card_id' => $this->integer()->comment('Очисні споруди (окрема облікова картка; табл. 5.22)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'tunnel_outline_coords' => $this->string()->comment('Координати контуру тунелю в межах проїзної частини (по окремим напрямкам руху) (геодані)'),
        ]);
        $this->addCommentOnTable('tunnel_card', 'Дані про тунель');
    
        // Table 5.20
        $this->createTable('tunnel_portal_card', [
            'tunnel_portal_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'purpose' => $this->text()->comment('Призначення порталу'),
            'tunnel_portal_type_id' => $this->integer()->comment('Тип порталу (згідно з [4])'),
            'thick' => $this->float()->comment('Товщина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'frame_material_id' => $this->integer()->comment('Матеріал оправи порталу (згідно з [4])'),
            'frame_capacity' => $this->float()->comment('Об\'єм оправи порталу (у кубічних метрах; з двома цифрами після коми)'),
            'another_first_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 1-го типу (згідно з [4])'),
            'another_first_type_capacity' => $this->float()->comment('Об\'єм інших елементів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_second_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 2-го типу (згідно з [4])'),
            'another_second_type_capacity' => $this->float()->comment('Об\'єм інших елементів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_third_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 3-го типу (згідно з [4])'),
            'another_third_type_capacity' => $this->float()->comment('Об\'єм інших елементів 3-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'foundation_depth' => $this->float()->comment('Глибина залягання фундаменту (у метрах; з двома цифрами після коми)'),
            'foundation_first_type_material_id' => $this->integer()->comment('Матеріал фундаменту 1-го типу (згідно з [4])'),
            'foundation_second_type_material_id' => $this->integer()->comment('Матеріал фундаменту 2-го типу (згідно з [4])'),
            'foundation_third_type_material_id' => $this->integer()->comment('Матеріал фундаменту 3-го типу (згідно з [4])'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
            'fortified_slope_material_id' => $this->integer()->comment('Матеріал укріплення укосів (згідно з [4])'),
        ]);
        $this->addCommentOnTable('tunnel_portal_card', 'Дані про портал тунелю');

        // Table 5.21
        $this->createTable('tunnel_body_card', [
            'tunnel_body_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'body_type_id' => $this->integer()->comment('Тип форми тіла (згідно з [4])'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'typical_project_id' => $this->integer()->comment('Типовий проект (згідно з [4])'),
            'body_material_id' => $this->integer()->comment('Матеріал тіла тунелю (згідно з [4])'),
            'carrier_type_id' => $this->integer()->comment('Тип елементів носіїв (згідно з [4])'),
            'arch_rings_reverse_count' => $this->integer()->comment('Кількість кілець із зворотнім склепінням'),
            'rings_another_count' => $this->integer()->comment('Кількість кілець без зворотних склепінь та розпірних плит'),
            'precast_plates_rings_count' => $this->integer()->comment('Кількість кілець із розпірними плитами'),
            'body_material_capacity' => $this->float()->comment('Об\'єм матеріалу тіла (у кубічних метрах; з двома цифрами після коми)'),
            'foundation_material_id' => $this->integer()->comment('Матеріал фундаменту (згідно з [4])'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
        ]);
        $this->addCommentOnTable('tunnel_body_card', 'Дані про тіло тунелю');

        // Table 5.22
        $this->createTable('sewage_card', [
            'sewage_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'location' => $this->text()->comment('Місце розташування'),
            'drainage_scheme_outer' => $this->integer()->comment('Схема організації поверхневого водовідведення (згідно з [4])'),
            'sewage_construction_type_id' => $this->integer()->comment('Тип очисної споруди (згідно з [4])'),
            'capacity_project' => $this->float()->comment('Проектна пропускна здатність (у кубічних метрах за секунду; з двома цифрами після коми)'),
            'capacity_fact' => $this->float()->comment('Фактична пропускна здатність (у кубічних метрах за секунду; з двома цифрами після коми)'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'technical_doc_id' => $this->integer()->comment('Назва технічної документації (згідно з [4])'),
            'technical_doc_location' => $this->text()->comment('Місце зберігання технічної документації'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
        ]);
        $this->addCommentOnTable('sewage_card', 'Дані про очисну споруду');

        // Table 5.23
        $this->createTable('technical_doc', [
            'technical_doc_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'name' => $this->text()->comment('Назва документу'),
            'date_add' => $this->integer()->comment('Дата документу (згідно з [4])'),
            'performer' => $this->text()->comment('Виконавець'),
            'location' => $this->text()->comment('Місце зберігання документу'),
        ]);
        $this->addCommentOnTable('technical_doc', 'Дані про технічну документацію');

        // Table 5.24
        $this->createTable('bridge', [
            'bridge_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'center_position' => $this->string()->comment('Положення середини споруди (псевдогеодані)'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'obstacle_type_id' => $this->integer()->comment('Вид перешкоди (згідно з [4])'),
            'long_scheme' => $this->text()->comment('Поздовжня схема'),
            'cross_scheme' => $this->text()->comment('Поперечна схема'),
            'construction_length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'material_id' => $this->integer()->comment('Матеріал споруди (згідно з [4])'),
            'height' => $this->float()->comment('Габарит по висоті (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Габарит по ширині (у метрах; з двома цифрами після коми)'),
            'sideway_width_left' => $this->float()->comment('Ширина тротуару ліворуч (у метрах; з двома цифрами після коми)'),
            'sideway_width_right' => $this->float()->comment('Ширина тротуару праворуч (у метрах; з двома цифрами після коми)'),
            'load' => $this->float()->comment('Вантажопідйомність (згідно з ДБН В.2.3-22)'),
            'load_additional' => $this->text()->comment('Додаткове навантаження'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'bridge_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.25)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('rally', 'Облікова відомість мостів');

        // Table 5.25
        $this->createTable('bridge_card', [
            'bridge_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'center_position' => $this->string()->comment('Положення середини споруди (псевдогеодані)'),
            'movement_direction' => $this->integer()->comment('Напрямок руху, що забезпечує споруда (згідно з [4])'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'year_reconstruction' => $this->text()->comment('Рік реконструкції'),
            'nearest_settlement_name' => $this->text()->comment('Назва найближчого населеного пункту'),
            'nearest_settlement_distance' => $this->float()->comment('Відстань до найближчого населеного пункту (в кілометрах; з двома цифрами після коми)'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'load' => $this->float()->comment('Вантажопідйомність (згідно з ДБН В.2.3-22)'),
            'load_additional' => $this->text()->comment('Додаткове навантаження'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'obstacle_type_id' => $this->integer()->comment('Вид перешкоди (згідно з [4])'),
            'obstacle_name' => $this->text()->comment('Власна назва перешкоди'),
            'watercourse_rmv_width' => $this->float()->comment('Ширина водотоку по дзеркалу РМВ (у метрах; з двома цифрами після коми)'),
            'flow_rmv_speed' => $this->float()->comment('Швидкість течії при РМВ (у метрах на секунду; з двома цифрами після коми)'),
            'watercourse_rvv_width' => $this->float()->comment('Ширина водотоку по дзеркалу РВВ (у метрах; з двома цифрами після коми)'),
            'flow_km_direction' => $this->integer()->comment('Напрямок течії по ходу кілометражу (згідно з [4])'),
            'road_category_id' => $this->integer()->comment('Категорія автомобільної дороги (згідно з [4])'),
            'rail_track_count' => $this->integer()->comment('Кількість колій залізниці'),
            'obstacle_top_width' => $this->float()->comment('Ширина земляного полотна перешкоди по верху (у метрах; з двома цифрами після коми)'),
            'cross_angle' => $this->float()->comment('Кут перетину (в градусах; з двома цифрами після коми)'),
            'overall_dimension' => $this->float()->comment('Габарит (у метрах; з двома цифрами після коми)'),
            'lane_count_forward' => $this->integer()->comment('Кількість смуг руху в прямому напрямку руху'),
            'lane_count_back' => $this->integer()->comment('Кількість смуг руху праворуч в зворотному напрямку руху'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'sideway_width_forward_left' => $this->float()->comment('Ширина тротуару ліворуч від прямого напрямку руху (у метрах; з двома цифрами після коми)'),
            'sideway_width_forward_right' => $this->float()->comment('Ширина тротуару праворуч від прямого напрямку руху (у метрах; з двома цифрами після коми)'),
            'bridge_under_height' => $this->float()->comment('Висота підмостового габариту (у метрах; з двома цифрами після коми)'),
            'bridge_under_width' => $this->float()->comment('Ширина підмостового габариту (у метрах; з двома цифрами після коми)'),
            'bridge_hole' => $this->float()->comment('Отвір моста (у метрах; з двома цифрами після коми)'),
            'span_long_scheme' => $this->text()->comment('Поздовжня схема прогонових будов по ходу кілометражу'),
            'slope_long_scheme' => $this->text()->comment('Поздовжня схема похилів'),
            'fence_construction_right_id' => $this->integer()->comment('Конструкція огородження праворуч (згідно з [4])'),
            'fence_height_right' => $this->float()->comment('Висота огородження праворуч (у метрах; з двома цифрами після коми)'),
            'fence_construction_left_id' => $this->integer()->comment('Конструкція огородження ліворуч (згідно з [4])'),
            'fence_height_left' => $this->float()->comment('Висота огородження ліворуч (у метрах; з двома цифрами після коми)'),
            'sidewalk_type_left' => $this->integer()->comment('Тип тротуару ліворуч (згідно з [4])'),
            'barrier_material_type_left' => $this->integer()->comment('Матеріал перил тротуару ліворуч (згідно з [4])'),
            'barrier_height_left' => $this->integer()->comment('Висота перил тротуару ліворуч (у метрах; з двома цифрами після коми)'),
            'sidewalk_type_right' => $this->integer()->comment('Тип тротуару праворуч (згідно з [4])'),
            'barrier_material_type_right' => $this->integer()->comment('Матеріал перил тротуару праворуч (згідно з [4])'),
            'barrier_height_right' => $this->integer()->comment('Висота перил тротуару праворуч (у метрах; з двома цифрами після коми)'),
            'roadway_material_id' => $this->integer()->comment('Матеріал верхнього шару покриття проїзної частини (згідно табл. 8.1 ДБН В.2.3-4)'),
            'antiseismic_type_id' => $this->integer()->comment('Типи антисейсмічних пристроїв (згідно з [4])'),
            'deformation_joint_type_id' => $this->integer()->comment('Типи деформаційних швів (згідно з [4])'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'drainage_type_id' => $this->integer()->comment('Тип водовідведення (згідно з [4])'),
            'drainage_tray_length' => $this->float()->comment('Загальна довжина лотків зливової каналізації (у метрах; з двома цифрами після коми)'),
            'regulatory_structure_left' => $this->integer()->comment('Регуляційні споруди лівобережні (згідно з [4])'),
            'regulatory_structure_right' => $this->integer()->comment('Регуляційні споруди правобережні (згідно з [4])'),
            'security_connection_availability' => $this->integer()->comment('Наявність охорони та зв\'язку (згідно з [4])'),
            'light_availability' => $this->integer()->comment('Наявність освітлення (згідно з [4])'),
            'inventory_device_availability' => $this->integer()->comment('Наявність інвентарних пристроїв для огляду та ремонту (згідно з [4])'),
            'stair_availability_begin_left' => $this->integer()->comment('Наявність сходів на початку споруди ліворуч (згідно з [4])'),
            'stair_availability_begin_right' => $this->integer()->comment('Наявність сходів на початку споруди праворуч (згідно з [4])'),
            'stair_availability_end_left' => $this->integer()->comment('Наявність сходів в кінці споруди ліворуч (згідно з [4])'),
            'stair_availability_end_right' => $this->integer()->comment('Наявність сходів в кінці споруди праворуч (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'purlin_card_id' => $this->integer()->comment('Прогони (окрема облікова картка; табл. 5.26)'),
            'pillar_card_id' => $this->integer()->comment('Опори (окрема облікова картка; табл. 5.27)'),
            'sewage_card_id' => $this->integer()->comment('Очисні споруди (окрема облікова картка; табл. 5.22)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'bridge_outline_coords' => $this->string()->comment('Координати контуру споруди в межах проїзної частини (по окремим напрямкам руху) (геодані)'),
            ]);
        $this->addCommentOnTable('bridge_card', 'Дані про міст');

        // Table 5.26
        $this->createTable('purlin_card', [
            'purlin_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'purlin_number' => $this->integer()->comment('Номер прогону'),
            'static_scheme' => $this->text()->comment('Статична схема'),
            'span_count' => $this->integer()->comment('Кількість прогонових будов в прогоні'),
            'span_same_numbers' => $this->text()->comment('Номери однакових прогонових будов в прогоні (ліворуч направо)'),
            'span_construction_type_id' => $this->integer()->comment('Тип конструкції прогонової будови (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'span_length' => $this->float()->comment('Повна довжина прогонової будови (у метрах; з двома цифрами після коми)'),
            'year_build' => $this->text()->comment('Рік виготовлення'),
            'load' => $this->integer()->comment('Проектне навантаження (згідно з [4])'),
            'typical_project_id' => $this->integer()->comment('Типовий проект (згідно з [4])'),
            'bearing_moving_type_id' => $this->integer()->comment('Типи рухомих опорних частин (згідно з [4])'),
            'bearing_not_moving_type_id' => $this->integer()->comment('Типи нерухомих опорних частин (згідно з [4])'),
            'cross_scheme' => $this->text()->comment('Поперечна схема'),
            'cross_joint_type_id' => $this->integer()->comment('Спосіб поперечного об\'єднання (згідно з [4])'),
            'girder_main_count' => $this->integer()->comment('Кількість головних балок'),
            'girder_main_center_height' => $this->float()->comment('Висота головної балки в центрі прогону (у метрах; з двома цифрами після коми)'),
            'girder_main_pillar_height' => $this->float()->comment('Висота головної балки на опорі (у метрах; з двома цифрами після коми)'),
            'girder_cross_count' => $this->integer()->comment('Кількість поперечних балок (діафрагм) в прогоні'),
            'girder_long_count' => $this->integer()->comment('Кількість поздовжніх балок у панелі'),
            'roadway_plate_thick' => $this->float()->comment('Товщина плити проїзної частини (в міліметрах; з двома цифрами після коми)'),
            'road_surface_thick' => $this->float()->comment('Товщина одягу проїзної частини (в міліметрах; з двома цифрами після коми)'),
            'load_additional' => $this->text()->comment('Додаткове навантаження'),
            'note' => $this->text()->comment('Примітки'),
        ]);
        $this->addCommentOnTable('purlin_card', 'Дані про прогін');

        // Table 5.27
        $this->createTable('pillar_card', [
            'pillar_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'pillar_same_numbers' => $this->text()->comment('Номери однакових опор (ціле число або їх сукупність)'),
            'pillar_construction_type_id' => $this->integer()->comment('Тип конструкції опори (згідно з [4])'),
            'total_height' => $this->float()->comment('Загальна висота опори (у метрах; з двома цифрами після коми)'),
            'massive_height' => $this->float()->comment('Висота масивної частини опори (у метрах; з двома цифрами після коми)'),
            'massive_width' => $this->float()->comment('Ширина масивної частини опори (у метрах; з двома цифрами після коми)'),
            'stud_count' => $this->integer()->comment('Кількість стояків'),
            'stud_cut' => $this->float()->comment('Переріз стояка (у метрах; з двома цифрами після коми)'),
            'bar_cut' => $this->float()->comment('Переріз ригеля (у метрах; з двома цифрами після коми)'),
            'bar_length' => $this->float()->comment('Переріз ригеля (у метрах; з двома цифрами після коми)'),
            'pile_count' => $this->integer()->comment('Кількість паль'),
            'pile_cut' => $this->float()->comment('Переріз паль (у метрах; з двома цифрами після коми)'),
            'material_id' => $this->integer()->comment('Матеріал опори (згідно з [4])'),
            'foundation_type__id' => $this->integer()->comment('Тип фундаменту (згідно з [4])'),
            'foundation_depth' => $this->float()->comment('Глибина закладання фундаменту (у метрах; з двома цифрами після коми)'),
            'fortified_conus_material_id' => $this->integer()->comment('Матеріал укріплення конусу (згідно з [4])'),
            'icebreaker_type_id' => $this->integer()->comment('Тип льодорізу (згідно з [4])'),
            'icebreaker_material_id' => $this->integer()->comment('Матеріал льодорізу (згідно з [4])'),
        ]);
        $this->addCommentOnTable('pillar_card', 'Дані про опору');

        // Table 5.28
        $this->createTable('underground_crossing', [
            'underground_crossing_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина підземної частини споруди (у метрах; з двома цифрами після коми)'),
            'cross_scheme' => $this->text()->comment('Поперечна схема'),
            'material_id' => $this->integer()->comment('Матеріал споруди (згідно з [4])'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'underground_crossing_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.29)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('underground_crossing', 'Облікова відомість підземних пішохідних переходів');

        // Table 5.29
        $this->createTable('underground_crossing_card', [
            'underground_crossing_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'nearest_settlement_name' => $this->text()->comment('Назва найближчого населеного пункту'),
            'nearest_settlement_distance' => $this->float()->comment('Відстань до найближчого населеного пункту (в кілометрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Технічний стан (згідно з [4])'),
            'length' => $this->float()->comment('Довжина підземної частини споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'slope_long_scheme' => $this->text()->comment('Поздовжня схема похилів'),
            'mound_height' => $this->float()->comment('Висота насипу над переходом (у метрах; з двома цифрами після коми)'),
            'stair_total_length' => $this->float()->comment('Загальна довжина сходів на вході та виході з підземного переходу (у метрах; з двома цифрами після коми)'),
            'drainage_tray_internal_type' => $this->integer()->comment('Тип лотків внутрішнього водовідведення (згідно з [4])'),
            'drainage_tray_internal_length' => $this->float()->comment('Загальна довжина лотків внутрішнього водовідведення (у метрах; з двома цифрами після коми)'),
            'drainage_tunnel_type' => $this->integer()->comment('Тип дренажних штолень (згідно з [4])'),
            'drainage_tunnel_length' => $this->float()->comment('Загальна довжина дренажних штолень (у метрах; з двома цифрами після коми)'),
            'drainage_other_internal_construction' => $this->integer()->comment('Наявність інших внутрішніх водовідвідних споруд (згідно з [4])'),
            'surface_material_id' => $this->integer()->comment('Матеріал покриття (згідно з [4])'),
            'ventilation_type_id' => $this->integer()->comment('Тип вентиляції (згідно з [4])'),
            'light_type_id' => $this->integer()->comment('Тип освітлення (згідно з [4])'),
            'antiseismic_type_id' => $this->integer()->comment('Типи антисейсмічних пристроїв (згідно з [4])'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'underground_crossing_portal_card_id' => $this->integer()->comment('Портали (окрема облікова картка; табл. 5.30)'),
            'underground_crossing_body_card_id' => $this->integer()->comment('Тіло тунелю (окрема облікова картка; табл. 5.31)'),
            'underground_crossing_add_on_card_id' => $this->integer()->comment('Надбудова (окрема облікова картка; табл. 5.32)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'underground_crossing_outline_coords' => $this->string()->comment('Координати контуру споруди в межах зони пішохідного руху (геодані)'),
        ]);
        $this->addCommentOnTable('underground_crossing_card', 'Дані про підземний пішохідний перехід');

        // Table 5.30
        $this->createTable('underground_crossing_portal_card', [
            'underground_crossing_portal_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'header_location' => $this->text()->comment('Розташування оголовку'),
            'underground_crossing_portal_type_id' => $this->integer()->comment('Тип порталу (згідно з [4])'),
            'thick' => $this->float()->comment('Товщина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'frame_material_id' => $this->integer()->comment('Матеріал оправи порталу (згідно з [4])'),
            'frame_capacity' => $this->float()->comment('Об\'єм оправи порталу (у кубічних метрах; з двома цифрами після коми)'),
            'another_first_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 1-го типу (згідно з [4])'),
            'another_first_type_capacity' => $this->float()->comment('Об\'єм інших елементів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_second_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 2-го типу (згідно з [4])'),
            'another_second_type_capacity' => $this->float()->comment('Об\'єм інших елементів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_third_type_material_id' => $this->integer()->comment('Матеріал інших елементів порталу 3-го типу (згідно з [4])'),
            'another_third_type_capacity' => $this->float()->comment('Об\'єм інших елементів 3-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
            'fortified_slope_material_id' => $this->integer()->comment('Матеріал укріплення укосів (згідно з [4])'),
        ]);
        $this->addCommentOnTable('underground_crossing_portal_card', 'Дані про портал підземного пішохідного переходу');

        // Table 5.31
        $this->createTable('underground_crossing_body_card', [
            'underground_crossing_body_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'body_type_id' => $this->integer()->comment('Тип форми тіла (згідно з [4])'),
            'thick' => $this->float()->comment('Товщина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'typical_project_id' => $this->integer()->comment('Типовий проект (згідно з [4])'),
            'body_material_id' => $this->integer()->comment('Матеріал стінової будови (згідно з [4])'),
            'body_material_capacity' => $this->float()->comment('Об\'єм матеріалу стінової будови (у кубічних метрах; з двома цифрами після коми)'),
            'overlap_type_id' => $this->integer()->comment('Тип конструкцій перекриття (згідно з [4])'),
            'overlap_material_id' => $this->integer()->comment('Матеріал конструкцій перекриття (згідно з [4])'),
            'overlap_material_capacity' => $this->float()->comment('Об\'єм матеріалу конструкцій перекриття (у кубічних метрах; з двома цифрами після коми)'),
            'foundation_material_id' => $this->integer()->comment('Матеріал фундаменту (згідно з [4])'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
        ]);
        $this->addCommentOnTable('underground_crossing_body_card', 'Дані про тіло підземного пішохідного переходу');

        // Table 5.32
        $this->createTable('underground_crossing_add_on_card', [
            'underground_crossing_add_on_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'location' => $this->text()->comment('Розташування надбудови'),
            'thick' => $this->float()->comment('Товщина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина (у метрах; з двома цифрами після коми)'),
            'wall_material_id' => $this->integer()->comment('Матеріал стін (згідно з [4])'),
            'roof_material_id' => $this->integer()->comment('Матеріал даху (згідно з [4])'),
            'wall_material_capacity' => $this->float()->comment('Об\'єм матеріалу стін (у кубічних метрах; з двома цифрами після коми)'),
            'roof_material_capacity' => $this->float()->comment('Об\'єм матеріалу даху (у кубічних метрах; з двома цифрами після коми)'),
            'first_add_on_coords' => $this->string()->comment('Координати 1-ї надбудови (геодані)'),
            'second_add_on_coords' => $this->string()->comment('Координати 2-ї надбудови (геодані)'),
        ]);
        $this->addCommentOnTable('underground_crossing_add_on_card', 'Дані про надбудови підземного пішохідного переходу');

        // Table 5.33
        $this->createTable('overground_crossing', [
            'overground_crossing_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'long_scheme' => $this->text()->comment('Поздовжня схема'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'add_on_availability' => $this->integer()->comment('Наявність надбудов (згідно з [4])'),
            'lift_availability' => $this->integer()->comment('Наявність пандусів, механічних підйомників на вході та виході із споруди (згідно з [4])'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'overground_crossing_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.34)'),
            'stair_total_length' => $this->float()->comment('Загальна довжина сходів на підході до споруди (у метрах; з двома цифрами після коми)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('overground_crossing', 'Облікова відомість надземних пішохідних переходів');

        // Table 5.34
        $this->createTable('overground_crossing_card', [
            'overground_crossing_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'year_reconstruction' => $this->text()->comment('Рік реконструкції'),
            'nearest_settlement_name' => $this->text()->comment('Назва найближчого населеного пункту'),
            'nearest_settlement_distance' => $this->float()->comment('Відстань до найближчого населеного пункту (в кілометрах; з двома цифрами після коми)'),
            'load_project' => $this->float()->comment('Проектне навантаження (в кілометрах; з двома цифрами після коми)'),
            'load_fact' => $this->float()->comment('Фактичне навантаження (в кілометрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Технічний стан (згідно з [4])'),
            'roadway_width' => $this->float()->comment('Ширина автомобільної дороги по верху земляного полотна (у метрах; з двома цифрами після коми)'),
            'cross_angle' => $this->float()->comment('Кут перетину (в градусах; з двома цифрами після коми)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'bridge_under_height' => $this->float()->comment('Висота підмостового габариту (у метрах; з двома цифрами після коми)'),
            'bridge_under_width' => $this->float()->comment('Ширина підмостового габариту (у метрах; з двома цифрами після коми)'),
            'bridge_hole' => $this->float()->comment('Отвір моста (у метрах; з двома цифрами після коми)'),
            'bearing_structures_long_scheme' => $this->text()->comment('Поздовжня схема несучих конструкцій ліворуч направо по ходу прямого напрямку руху'),
            'slope_long_scheme' => $this->text()->comment('Поздовжня схема похилів'),
            'barrier_material_type_id' => $this->integer()->comment('Матеріал перил (згідно з [4])'),
            'barrier_height' => $this->integer()->comment('Висота перил (у метрах; з двома цифрами після коми)'),
            'surface_material_id' => $this->integer()->comment('Покриття пішохідної частини'),
            'antiseismic_type_id' => $this->integer()->comment('Типи антисейсмічних пристроїв (згідно з [4])'),
            'deformation_joint_type_id' => $this->integer()->comment('Типи деформаційних швів (згідно з [4])'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'drainage_type_id' => $this->integer()->comment('Тип водовідведення (згідно з [4])'),
            'drainage_tray_length' => $this->float()->comment('Загальна довжина лотків зливової каналізації (у метрах; з двома цифрами після коми)'),
            'drainage_collector_length' => $this->float()->comment('Загальна довжина колекторів зливової каналізації (у метрах; з двома цифрами після коми)'),
            'approach_left' => $this->integer()->comment('Споруди підходів ліворуч (згідно з [4])'),
            'approach_right' => $this->integer()->comment('Споруди підходів праворуч (згідно з [4])'),
            'add_on_availability' => $this->integer()->comment('Надбудова (згідно з [4])'),
            'light_availability' => $this->integer()->comment('Наявність штучного освітлення (згідно з [4])'),
            'inventory_device_availability' => $this->integer()->comment('Наявність інвентарних пристроїв для огляду та ремонту (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'purlin_card_id' => $this->integer()->comment('Прогони (окрема облікова картка; табл. 5.26)'),
            'pillar_card_id' => $this->integer()->comment('Опори (окрема облікова картка; табл. 5.27)'),
            'approach_card_id' => $this->integer()->comment('Підходи (окрема облікова картка; табл. 5.35)'),
            'sewage_card_id' => $this->integer()->comment('Очисні споруди (окрема облікова картка; табл. 5.22)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'overground_crossing_outline_coords' => $this->string()->comment('Координати контуру споруди в межах пішохідної зони (геодані)'),
        ]);
        $this->addCommentOnTable('overground_crossing_card', 'Дані про надземний пішохідний перехід');

        // Table 5.35
        $this->createTable('overground_crossing_approach_card', [
            'overground_crossing_approach_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'location' => $this->text()->comment('Розташування споруди'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'another_first_type_material_id' => $this->integer()->comment('Матеріал споруди 1-го типу (згідно з [4])'),
            'another_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_second_type_material_id' => $this->integer()->comment('Матеріал споруди 2-го типу (згідно з [4])'),
            'another_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'another_third_type_material_id' => $this->integer()->comment('Матеріал споруди 3-го типу (згідно з [4])'),
            'another_third_type_capacity' => $this->float()->comment('Об\'єм матеріалів 3-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'related_lift_construction_left_type_id' => $this->integer()->comment('Тип супутніх підйомних споруд ліворуч (згідно з [4])'),
            'related_lift_construction_right_type_id' => $this->integer()->comment('Тип супутніх підйомних споруд праворуч (згідно з [4])'),
            'construction_coords_left' => $this->string()->comment('Координати споруди ліворуч (геодані)'),
            'construction_coords_right' => $this->string()->comment('Координати споруди праворуч (геодані)'),
        ]);
        $this->addCommentOnTable('overground_crossing_approach_card', 'Дані про підходи до надземного пішохідного переходу');

        // Table 5.36
        $this->createTable('sel_protection', [
            'sel_protection_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення предмета захисту (псевдогеодані)'),
            'road_distance' => $this->float()->comment('Відстань від дороги (у метрах; з двома цифрами після коми)'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'sel_protection_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.37)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('sel_protection', 'Облікова відомість селезахисних споруд');

        // Table 5.37
        $this->createTable('sel_protection_card', [
            'sel_protection_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'location' => $this->text()->comment('Розташування споруди'),
            'position' => $this->string()->comment('Положення предмета захисту (псевдогеодані)'),
            'protection_object_id' => $this->integer()->comment('Предмет захисту (згідно з [4])'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'road_distance' => $this->float()->comment('Відстань від дороги (у метрах; з двома цифрами після коми)'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'year_reconstruction' => $this->text()->comment('Рік реконструкції'),
            'nearest_settlement_name' => $this->text()->comment('Назва найближчого населеного пункту'),
            'nearest_settlement_distance' => $this->float()->comment('Відстань до найближчого населеного пункту (в кілометрах; з двома цифрами після коми)'),
            'load_project' => $this->float()->comment('Проектне навантаження (в тоннах; з двома цифрами після коми)'),
            'load_fact' => $this->float()->comment('Фактичне навантаження (в тоннах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'thalweg_type_id' => $this->integer()->comment('Тип тальвегу (згідно з [4])'),
            'watercourse_rmv_width' => $this->float()->comment('Ширина водотоку по дзеркалу РМВ (у метрах; з двома цифрами після коми)'),
            'flow_rmv_speed' => $this->float()->comment('Швидкість течії при РМВ (у метрах на секунду; з двома цифрами після коми)'),
            'watercourse_rvv_width' => $this->float()->comment('Ширина водотоку по дзеркалу РВВ (у метрах; з двома цифрами після коми)'),
            'cross_angle' => $this->float()->comment('Кут перетину (в градусах; з двома цифрами після коми)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'material_id' => $this->integer()->comment('Матеріал споруди (згідно з [4])'),
            'capacity' => $this->float()->comment('Об\'єм споруди (у кубічних метрах; з двома цифрами після коми)'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'drainage_type_id' => $this->integer()->comment('Тип водовідведення (згідно з [4])'),
            'drainage_length' => $this->float()->comment('Загальна довжина водовідвідних елементів (у метрах; з двома цифрами після коми)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'drainage_pipe_card_id' => $this->integer()->comment('Картка водовідвідної труби (окрема облікова картка; табл. 5.39)'),
            'drainage_card_id' => $this->integer()->comment('Картка дренажної системи (окрема облікова картка; табл. 5.52)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'sel_protection_outline_coords' => $this->string()->comment('Координати контуру споруди (геодані)'),
        ]);
        $this->addCommentOnTable('sel_protection_card', 'Дані про селезахисну споруду');

        // Table 5.38
        $this->createTable('drainage_pipe', [
            'drainage_pipe_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення предмета захисту (псевдогеодані)'),
            'obstacle_type_id' => $this->integer()->comment('Вид перешкоди (згідно з [4])'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'culvert_elements_entrance_count' => $this->integer()->comment('Кількість ВПЕ на вході'),
            'culvert_elements_exit_count' => $this->integer()->comment('Кількість ВПЕ на виході'),
            'header_entrance_count' => $this->integer()->comment('Кількість оголовків на вході'),
            'header_exit_count' => $this->integer()->comment('Кількість оголовків на виході'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'drainage_pipe_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.39)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('drainage_pipe', 'Облікова відомість труб водопропускних');

        // Table 5.39
        $this->createTable('drainage_pipe_card', [
            'drainage_pipe_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення споруди (псевдогеодані)'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'year_reconstruction' => $this->text()->comment('Рік реконструкції'),
            'obstacle_type_id' => $this->integer()->comment('Вид перешкоди (згідно з [4])'),
            'flow_km_direction' => $this->integer()->comment('Напрямок течії по ходу кілометражу (згідно з [4])'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації, яка перепускається спорудою (згідно з [4])'),
            'road_surface_up_height' => $this->float()->comment('Висота земляного полотна над трубою (у метрах; з двома цифрами після коми)'),
            'culvert_elements_entrance_count' => $this->integer()->comment('Кількість ВПЕ на вході'),
            'culvert_elements_exit_count' => $this->integer()->comment('Кількість ВПЕ на виході'),
            'header_entrance_count' => $this->integer()->comment('Кількість оголовків на вході'),
            'header_exit_count' => $this->integer()->comment('Кількість оголовків на виході'),
            'culvert_elements_area' => $this->float()->comment('Сумарна площа всіх ВПЕ (у квадратних метрах; з двома цифрами після коми)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'culvert_element_card_id' => $this->integer()->comment('Картка ВПЕ (окрема облікова картка; табл. 5.40)'),
            'header_card_id' => $this->integer()->comment('Картка оголовка (окрема облікова картка; табл. 5.41)'),
            'technical_doc_id' => $this->integer()->comment('Технічна документація (окрема облікова картка; табл. 5.23)'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'culvert_elements_one_coords' => $this->string()->comment('Координати вісі ВПЕ No 1 (геодані)'),
            'culvert_elements_two_coords' => $this->string()->comment('Координати вісі ВПЕ No 2 (геодані)'),
            'culvert_elements_three_coords' => $this->string()->comment('Координати вісі ВПЕ No 3 (геодані)'),
            'culvert_elements_four_coords' => $this->string()->comment('Координати вісі ВПЕ No 4 (геодані)'),
            'culvert_elements_five_coords' => $this->string()->comment('Координати вісі ВПЕ No 5 (геодані)'),
        ]);
        $this->addCommentOnTable('drainage_pipe_card', 'Дані про трубу водопропускну');

        // Table 5.40
        $this->createTable('culvert_element_card', [
            'culvert_element_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'culvert_element_number' => $this->integer()->comment('Номер ВПЕ'),
            'section_long_scheme' => $this->text()->comment('Поздовжня схема перерізів'),
            'section_type_id' => $this->integer()->comment('Тип перерізу (згідно з [4])'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'height' => $this->float()->comment('Висота отвору (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина отвору (у метрах; з двома цифрами після коми)'),
            'culvert_element_work_id' => $this->integer()->comment('Характер роботи ВПЕ (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'fortified_additional_bottom' => $this->integer()->comment('Додаткове укріплення дна (згідно з [4])'),
            'capacity' => $this->float()->comment('Об\'єм тіла ВПЕ (у кубічних метрах; з двома цифрами після коми)'),
            'foundation_thick' => $this->float()->comment('Товщина фундаменту (у метрах; з двома цифрами після коми)'),
            'foundation_material_id' => $this->integer()->comment('Матеріал фундаменту (згідно з [4])'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
            'waterproof_type_id' => $this->integer()->comment('Тип гідроізоляції (згідно з [4])'),
        ]);
        $this->addCommentOnTable('culvert_element_card', 'Дані про ВПЕ');

        // Table 5.41
        $this->createTable('header_card', [
            'header_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'purpose' => $this->text()->comment('Призначення оголовка'),
            'culvert_elements_junction_numbers' => $this->text()->comment('Номери ВПЕ, поєднаних оголовком'),
            'header_type_id' => $this->integer()->comment('Тип оголовка (згідно з [4])'),
            'header_first_type_material_id' => $this->integer()->comment('Матеріал портальної стінки порталу 1-го типу (згідно з [4])'),
            'header_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'header_second_type_material_id' => $this->integer()->comment('Матеріал портальної стінки порталу 2-го типу (згідно з [4])'),
            'header_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'wing_material_id' => $this->integer()->comment('Матеріал відкрилків (згідно з [4])'),
            'wing_capacity' => $this->integer()->comment('Об\'єм тіла відкрилків (у кубічних метрах; з двома цифрами після коми)'),
            'foundation_thick' => $this->float()->comment('Товщина фундаменту (у метрах; з двома цифрами після коми)'),
            'foundation_material_id' => $this->integer()->comment('Матеріал фундаменту (згідно з [4])'),
            'basement_type_id' => $this->integer()->comment('Тип основи (згідно з [4])'),
            'foundation_basement_capacity' => $this->float()->comment('Загальний об\'єм фундаменту та основи (у кубічних метрах; з двома цифрами після коми)'),
            'fortified_channel_material_id' => $this->integer()->comment('Матеріал укріплення русла (згідно з [4])'),
            'regulatory_type_id' => $this->integer()->comment('Тип регуляційних елементів (згідно з [4])'),
            'fortified_mound_header_material_id' => $this->integer()->comment('Матеріал укріплення насипу біля оголовка (згідно з [4])'),
        ]);
        $this->addCommentOnTable('header_card', 'Дані про оголовок');

        // Table 5.42
        $this->createTable('bus_stop', [
            'bus_stop_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_id' => $this->integer()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'region_id' => $this->integer()->comment('Область'),
            'settlement_id' => $this->integer()->comment('Назва населеного пункту'),
            'location_left' => $this->float()->comment('Місцезнаходження, км+ зліва'),
            'location_right' => $this->float()->comment('Місцезнаходження, км+ справа'),
            'surface_type_id' => $this->integer()->comment('Покриття посадочного майданчика (згідно з [4])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення споруди (псевдогеодані)'),
            'area_stop_availability' => $this->integer()->comment('Наявність автопавільйона (згідно з [4])'),
            'pocket_availability' => $this->integer()->comment('Наявність заїзної кишені (згідно з [4])'),
            'area_land_availability' => $this->integer()->comment('Наявність посадкового майданчика з удосконаленим покриттям (згідно з [4])'),
            'toilet_availability' => $this->integer()->comment('Наявність туалета (згідно з [4])'),
            'state_common_id' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'bus_station_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.43)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'year_build' => $this->integer()->comment('Рік побудови'),
            'year_repair' => $this->integer()->comment('Рік реконструкції'),
        ]);
        $this->addCommentOnTable('bus_stop', 'Облікова відомість автобусних зупинок та автопавільйонів');

        // Table 5.43
        $this->createTable('bus_stop_card', [
            'bus_stop_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'name' => $this->text()->comment('Власна назва'),
            'area_stop_availability' => $this->integer()->comment('Наявність автопавільйона (згідно з [4])'),
            'pocket_availability' => $this->integer()->comment('Наявність заїзної кишені (згідно з [4])'),
            'area_land_availability' => $this->integer()->comment('Наявність посадкового майданчика з удосконаленим покриттям (згідно з [4])'),
            'toilet_availability' => $this->integer()->comment('Наявність туалета (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'pavilion_card_id' => $this->integer()->comment('Автопавільйон (згідно з [4])'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'construction_center_coords' => $this->string()->comment('Координати центру споруди (геодані)'),
        ]);
        $this->addCommentOnTable('bus_stop_card', 'Дані про автобусну зупинку');

        // Table 5.44
        $this->createTable('pavilion_card', [
            'pavilion_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'roof_first_type_material_id' => $this->integer()->comment('Матеріал даху 1-го типу (згідно з [4])'),
            'roof_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'roof_second_type_material_id' => $this->integer()->comment('Матеріал даху 2-го типу (згідно з [4])'),
            'roof_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'wall_first_type_material_id' => $this->integer()->comment('Матеріал стін 1-го типу (згідно з [4])'),
            'wall_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'wall_second_type_material_id' => $this->integer()->comment('Матеріал стін 2-го типу (згідно з [4])'),
            'wall_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'pavilion_outline_coords' => $this->string()->comment('Координати контуру павільйону (геодані)'),
        ]);
        $this->addCommentOnTable('pavilion_card', 'Дані про автопавільйон');

        // Table 5.45
        $this->createTable('retaining_wall', [
            'retaining_wall_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення середини споруди (псевдогеодані)'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'retaining_wall_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.46)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('retaining_wall', 'Облікова відомість підпірних стінок');

        // Table 5.46
        $this->createTable('retaining_wall_card', [
            'retaining_wall_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Положення початку споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Положення кінця споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'purpose' => $this->integer()->comment('Призначення споруди (згідно з [4])'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'year_reconstruction' => $this->text()->comment('Рік реконструкції'),
            'material_id' => $this->integer()->comment('Матеріал споруди (згідно з [4])'),
            'drainage_wall_availability' => $this->integer()->comment('Наявність застінного дренажу (згідно з [4])'),
            'material_capacity' => $this->float()->comment('Об\'єм матеріалів в споруді (у кубічних метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'construction_coords' => $this->string()->comment('Координати вісі споруди (геодані)'),
        ]);
        $this->addCommentOnTable('retaining_wall_card', 'Дані про підпірну стінку');

        // Table 5.47
        $this->createTable('stabilisation_field', [
            'stabilisation_field_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'purpose' => $this->text()->comment('Призначення споруди'),
            'area' => $this->float()->comment('Площа (у квадратних метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'stabilisation_field_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.48)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'monitor_result' => $this->text()->comment('Результати моніторингу'),
            'date_monitor' => $this->integer()->comment('Дата моніторингу (згідно з [4])'),
        ]);
        $this->addCommentOnTable('stabilisation_field', 'Облікова відомість стабілізаційних полів');

        // Table 5.48
        $this->createTable('stabilisation_field_card', [
            'stabilisation_field_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'area' => $this->float()->comment('Площа споруди (у квадратних метрах; з двома цифрами після коми)'),
            'pile_type_id' => $this->integer()->comment('Тип паль (згідно з [4])'),
            'pile_cut' => $this->float()->comment('Переріз паль (у метрах; з двома цифрами після коми)'),
            'pile_length' => $this->float()->comment('Довжина паль (у метрах; з двома цифрами після коми)'),
            'pile_count' => $this->integer()->comment('Кількість паль'),
            'year_build' => $this->text()->comment('Рік побудови'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'monitor_result' => $this->text()->comment('Результати моніторингу'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'construction_outline_coords' => $this->string()->comment('Координати контуру споруди (геодані)'),
        ]);
        $this->addCommentOnTable('stabilisation_field_card', 'Дані про стабілізаційне поле');

        // Table 5.49
        $this->createTable('tray', [
            'tray_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->integer()->comment('Призначення (згідно з [4])'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'tray_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.50)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('tray', 'Облікова відомість лотків');

        // Table 5.50
        $this->createTable('tray_card', [
            'tray_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Положення початку споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Положення кінця споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'body_material_id' => $this->integer()->comment('Матеріал тіла споруди (згідно з [4])'),
            'body_material_capacity' => $this->float()->comment('Об\'єм матеріалів тіла споруди (у кубічних метрах; з двома цифрами після коми)'),
            'basement_material_id' => $this->integer()->comment('Матеріал основи споруди (згідно з [4])'),
            'basement_material_capacity' => $this->float()->comment('Об\'єм матеріалів основи споруди (у кубічних метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'construction_coords' => $this->string()->comment('Координати вісі споруди (геодані)'),
        ]);
        $this->addCommentOnTable('tray_card', 'Дані про лоток, перепад, швидкотік');

        // Table 5.51
        $this->createTable('drainage', [
            'drainage_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'drainage_construction_type_id' => $this->integer()->comment('Тип конструкції дренажу (згідно з [4])'),
            'drainage_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.52)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('drainage', 'Облікова відомість дренажних споруд');

        // Table 5.52
        $this->createTable('drainage_card', [
            'drainage_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Положення початку споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Положення кінця споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'drainage_construction_type_id' => $this->integer()->comment('Тип конструкції дренажу (згідно з [4])'),
            'manhole_count' => $this->integer()->comment('Кількість оглядових колодязів'),
            'manhole_first_type_material_id' => $this->integer()->comment('Матеріал оглядових колодязів 1-го типу (згідно з [4])'),
            'manhole_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів оглядових колодязів 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'manhole_second_type_material_id' => $this->integer()->comment('Матеріал оглядових колодязів 2-го типу (згідно з [4])'),
            'manhole_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів оглядових колодязів 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'drainage_pipe_first_type_material_id' => $this->integer()->comment('Матеріал дренажних труб 1-го типу (згідно з [4])'),
            'drainage_pipe_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів дренажних труб 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'drainage_pipe_second_type_material_id' => $this->integer()->comment('Матеріал дренажних труб 2-го типу (згідно з [4])'),
            'drainage_pipe_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів дренажних труб 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'drainage_pipe_third_type_material_id' => $this->integer()->comment('Матеріал дренажних труб 3-го типу (згідно з [4])'),
            'drainage_pipe_third_type_capacity' => $this->float()->comment('Об\'єм матеріалів дренажних труб 3-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'drainage_pipe_fourth_type_material_id' => $this->integer()->comment('Матеріал дренажних труб 4-го типу (згідно з [4])'),
            'drainage_pipe_fourth_type_capacity' => $this->float()->comment('Об\'єм матеріалів дренажних труб 4-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'exhaust_construction_first_type_material_id' => $this->integer()->comment('Матеріал випускної споруди 1-го типу (згідно з [4])'),
            'exhaust_construction_first_type_capacity' => $this->float()->comment('Об\'єм матеріалів випускної споруди 1-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'exhaust_construction_second_type_material_id' => $this->integer()->comment('Матеріал випускної споруди 2-го типу (згідно з [4])'),
            'exhaust_construction_second_type_capacity' => $this->float()->comment('Об\'єм матеріалів випускної споруди 2-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'exhaust_construction_third_type_material_id' => $this->integer()->comment('Матеріал випускної споруди 3-го типу (згідно з [4])'),
            'exhaust_construction_third_type_capacity' => $this->float()->comment('Об\'єм матеріалів випускної споруди 3-го типу (у кубічних метрах; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'draft' => $this->string()->comment('Креслення (pdf [3])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'construction_up_coords' => $this->string()->comment('Координати вісі споруди по верху (геодані)'),
            'construction_down_coords' => $this->string()->comment('Координати вісі споруди по низу (геодані)'),
        ]);
        $this->addCommentOnTable('drainage_card', 'Дані про дренажну споруду');

        // Table 5.53
        $this->createTable('site', [
            'site_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення середини споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення майданчика'),
            'surface_type_id' => $this->integer()->comment('Тип покриття (згідно з [4])'),
            'area' => $this->float()->comment('Площа покриття стоянки (у квадратних метрах; з двома цифрами після коми)'),
            'site_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.54)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('site', 'Облікова відомість майданчиків');

        // Table 5.54
        $this->createTable('site_card', [
            'site_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення майданчика'),
            'surface_type_id' => $this->integer()->comment('Тип покриття (згідно з [4])'),
            'area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'improvement_card_id' => $this->integer()->comment('Елементи благоустрою (окрема облікова картка; табл. 5.55)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'construction_outline_coords' => $this->string()->comment('Координати контуру споруди (геодані)'),
            'construction_center_coords' => $this->string()->comment('Координати вісі споруди по верху (геодані)'),
        ]);
        $this->addCommentOnTable('site_card', 'Дані про майданчик');

        // Table 5.55
        $this->createTable('improvement_card', [
            'improvement_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'improvement_miss' => $this->integer()->comment('Благоустрій відсутній (згідно з [4])'),
            'water_drink' => $this->integer()->comment('Вода питна (згідно з [4])'),
            'water_technical' => $this->integer()->comment('Вода технічна (згідно з [4])'),
            'trestle' => $this->integer()->comment('Естакада (згідно з [4])'),
            'terminal_informational' => $this->integer()->comment('Інформаційний термінал (згідно з [4])'),
            'architecture_form_small' => $this->integer()->comment('Малі архітектурні форми (згідно з [4])'),
            'light' => $this->integer()->comment('Освітлення (згідно з [4])'),
            'security' => $this->integer()->comment('Охорона (згідно з [4])'),
        ]);
        $this->addCommentOnTable('improvement_card', 'Дані про елемент благоустрою');

        // Table 5.56
        $this->createTable('sidewalk', [
            'sidewalk_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'settlement_name' => $this->text()->comment('Назва населеного пункту'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'surface_type_id' => $this->integer()->comment('Тип покриття (згідно з [4])'),
            'area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'sidewalk_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.57)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('sidewalk', 'Облікова відомість тротуарів та велодоріжок');

        // Table 5.57
        $this->createTable('sidewalk_card', [
            'sidewalk_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'length' => $this->float()->comment('Довжина споруди (у метрах; з двома цифрами після коми)'),
            'width' => $this->float()->comment('Ширина споруди (у метрах; з двома цифрами після коми)'),
            'constrution_type_id' => $this->integer()->comment('Тип споруди (згідно з [4])'),
            'road_surface_id' => $this->integer()->comment('Дорожній одяг (окрема облікова картка; табл. 5.9)'),
            'area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'construction_outline_coords' => $this->string()->comment('Координати контуру споруди (геодані)'),
        ]);
        $this->addCommentOnTable('sidewalk_card', 'Дані про тротуар, велодоріжку');

        // Table 5.58
        $this->createTable('fence', [
            'fence_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'fence_type_id' => $this->integer()->comment('Тип огородження (згідно з [4])'),
            'fence_construction_type_id' => $this->integer()->comment('Тип конструкції огородження (згідно з [4])'),
            'fence_construction_id' => $this->integer()->comment('Конструкція огородження (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал огородження (згідно з [4])'),
            'stud_material_id' => $this->integer()->comment('Матеріал стояків (згідно з [4])'),
            'fence_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.59)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('fence', 'Облікова відомість огороджень');

        // Table 5.59
        $this->createTable('fence_card', [
            'fence_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'fence_type_id' => $this->integer()->comment('Тип огородження (згідно з ДСТУ 2735)'),
            'fence_construction_id' => $this->integer()->comment('Конструкція огородження (згідно з [4])'),
            'material_id' => $this->integer()->comment('Матеріал елементів огородження (згідно з [4])'),
            'stud_material_id' => $this->integer()->comment('Матеріал стояків (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'construction_coords' => $this->string()->comment('Координати вісі споруди (геодані)'),
        ]);
        $this->addCommentOnTable('fence_card', 'Дані про окрему ділянку огородження');

        // Table 5.60
        $this->createTable('direct_device', [
            'direct_device_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок сукупності пристроїв (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець сукупності пристроїв (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'direct_device_type_id' => $this->integer()->comment('Тип напрямного пристрою (згідно з [4])'),
            'device_count' => $this->integer()->comment('Кількість елементів в групі'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'direct_device_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.61)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('direct_device', 'Облікова відомість напрямних пристроїв');

        // Table 5.61
        $this->createTable('direct_device_card', [
            'direct_device_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок сукупності пристроїв (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець сукупності пристроїв (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'direct_device_type_id' => $this->integer()->comment('Тип напрямного пристрою (згідно з [4])'),
            'device_count' => $this->integer()->comment('Кількість елементів в групі'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'reflective_element_availability' => $this->integer()->comment('Наявність світлоповертаючих елементів (згідно з [4])'),
            'artificial_light_availability' => $this->integer()->comment('Наявність штучної підствітки (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'construction_coords' => $this->string()->comment('Координати елементів сукупності (геодані)'),
        ]);
        $this->addCommentOnTable('direct_device_card', 'Дані про напрямний пристрій або їх сукупність');

        // Table 5.62
        $this->createTable('noise_dazzle_protection', [
            'noise_dazzle_protection_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'purpose' => $this->text()->comment('Призначення'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'noise_dazzle_protection_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.63 - 5.64)'),
            'state' => $this->integer()->comment('Стан споруди (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('noise_dazzle_protection', 'Облікова шумозахисних та протизасліплювальних споруд');

        // Table 5.63
        $this->createTable('dazzle_protection_card', [
            'dazzle_protection_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення споруди'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'construction_coords' => $this->string()->comment('Координати вісі споруди (геодані)'),
        ]);
        $this->addCommentOnTable('dazzle_protection_card', 'Дані про протизасліплювальну споруду');

        // Table 5.64
        $this->createTable('noise_protection_card', [
            'noise_protection_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок споруди (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець споруди (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення споруди'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'height' => $this->float()->comment('Висота споруди (у метрах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'break_counter_screen_availability' => $this->integer()->comment('Наявність розривів та контр-екранів (згідно з [4])'),
            'drainage_availability' => $this->integer()->comment('Наявність водовідведення (згідно з [4])'),
            'vibration_absorbing_availability' => $this->integer()->comment('Наявність пружних вібропоглинаючих прокладок між секціями (згідно з [4])'),
            'sound_reflect_cassette_material_id' => $this->integer()->comment('Матеріал звуковідбивних касет (згідно з [4])'),
            'sound_absorbing_cassette_material_id' => $this->integer()->comment('Матеріал звукопоглинальних касет (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'acoustic_project_effectivity' => $this->text()->comment('Проектна акустична ефективність'),
            'acoustic_effectivity_indicator' => $this->text()->comment('Показник акустичної ефективності споруди'),
            'exploitation_instruction_availability' => $this->integer()->comment('Наявніть інструкції з експлуатації (згідно з [4])'),
            'project_doc_location' => $this->text()->comment('Місце зберігання проектної документації'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'act_work_performed' => $this->text()->comment('Акт виконаних робіт (pdf [3])'),
            'repair_certificate' => $this->string()->comment('Довідка про виконання ремонтних робіт (pdf [3])'),
            'construction_coords' => $this->string()->comment('Координати вісі споруди (геодані)'),
        ]);
        $this->addCommentOnTable('noise_protection_card', 'Дані про шумозахисну споруду');

        // Table 5.65
        $this->createTable('road_sign', [
            'road_sign_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'size_typical' => $this->integer()->comment('Типорозмір (згідно з 3.17 ДСТУ 4100)'),
            'number' => $this->integer()->comment('Типорозмір (згідно з 3.2 ДСТУ 4100)'),
            'text' => $this->text()->comment('Текст'),
            'location' => $this->text()->comment('Розташування'),
            'purpose_direction' => $this->text()->comment('Призначення для напрямку руху'),
            'fasten_type_id' => $this->integer()->comment('Тип кріплення знаку (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'defects' => $this->text()->comment('Дефекти'),
            'road_sign_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.66)'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('road_sign', 'Облікова відомість знаків дорожніх');

        // Table 5.66
        $this->createTable('road_sign_card', [
            'road_sign_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'size_typical' => $this->integer()->comment('Типорозмір (згідно з 3.17 ДСТУ 4100)'),
            'number' => $this->integer()->comment('Типорозмір (згідно з 3.2 ДСТУ 4100)'),
            'text' => $this->text()->comment('Текст'),
            'location' => $this->text()->comment('Розташування'),
            'purpose_direction' => $this->text()->comment('Призначення для напрямку руху'),
            'fasten_type_id' => $this->integer()->comment('Тип кріплення знаку (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'defects' => $this->text()->comment('Дефекти'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('road_sign_card', 'Дані про знак дорожній');

        // Table 5.67
        $this->createTable('road_mark', [
            'road_mark_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'area' => $this->float()->comment('Площа покриття (у квадратних метрах; з двома цифрами після коми)'),
            'group' => $this->integer()->comment('Група розмітки (згідно з 4.1 ДСТУ 2587)'),
            'number' => $this->integer()->comment('Номер розмітки (згідно з 4.1 ДСТУ 2587)'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'reflective_element_availability' => $this->integer()->comment('Наявність світлоповертальних елементів (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість споруди (у тисячах гривень; з двома цифрами після коми)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'road_mark_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.68)'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('road_mark', 'Облікова відомість розміток дорожніх');

        // Table 5.68
        $this->createTable('road_mark_card', [
            'road_mark_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'area' => $this->float()->comment('Площа (у квадратних метрах; з двома цифрами після коми)'),
            'group' => $this->integer()->comment('Група розмітки (згідно з 4.1 ДСТУ 2587)'),
            'number' => $this->integer()->comment('Номер розмітки (згідно з 4.1 ДСТУ 2587)'),
            'material_id' => $this->integer()->comment('Матеріал (згідно з [4])'),
            'reflective_element_availability' => $this->integer()->comment('Наявність світлоповертальних елементів (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
        ]);
        $this->addCommentOnTable('road_mark_card', 'Дані про розмітку дорожню');

        // Table 5.69
        $this->createTable('planting', [
            'planting_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення'),
            'tree_lane_count' => $this->integer()->comment('Кількість рядів дерев'),
            'lane_width_average' => $this->float()->comment('Середня ширина смуги (у метрах; з двома цифрами після коми)'),
            'area' => $this->float()->comment('Площа (у квадратних метрах; з двома цифрами після коми)'),
            'year_build' => $this->text()->comment('Рік висадження'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->text()->comment('Дефекти'),
            'planting_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.70)'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('planting', 'Облікова відомість штучних насаджень');

        // Table 5.70
        $this->createTable('planting_card', [
            'planting_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'purpose' => $this->text()->comment('Призначення'),
            'road_distance' => $this->float()->comment('Відстань від крайки проїзної частини дороги до найближчого краю стовбура дерева першого ряду насаджень (у метрах; з двома цифрами після коми)'),
            'tree_assortment' => $this->text()->comment('Асортимент порід дерев і кущів'),
            'tree_row_count' => $this->integer()->comment('Кількість рядів дерев'),
            'lane_width_average' => $this->float()->comment('Середня ширина смуги озеленення (у метрах; з двома цифрами після коми)'),
            'tree_top_height' => $this->float()->comment('Найвища висота дерева (у метрах; з двома цифрами після коми)'),
            'tree_crown_width' => $this->float()->comment('Ширина крони дерева (у метрах; з двома цифрами після коми)'),
            'tree_crown_density' => $this->text()->comment('Щільність (ажурність) крони дерев'),
            'tree_crown_height' => $this->float()->comment('Висота крони дерев (у метрах; з двома цифрами після коми)'),
            'tree_lane_distance' => $this->float()->comment('Відстань міждеревами в ряду (у метрах; з двома цифрами після коми)'),
            'area' => $this->float()->comment('Площа (у квадратних метрах; з двома цифрами після коми)'),
            'year_build' => $this->text()->comment('Рік висадження'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'photo' => $this->string()->comment('Фотографії (tiff [3])'),
            'video' => $this->string()->comment('Відео файли (mkv [3])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
        ]);
        $this->addCommentOnTable('planting_card', 'Дані про штучні насадження');

        // Table 5.71
        $this->createTable('data_collector', [
            'data_collector_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'data_collector_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.72)'),
            'link' => $this->text()->comment('Посилання на інтернет-ресурси'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('data_collector', 'Облікова відомість автоматичних електронних засобів збору даних');

        // Table 5.72
        $this->createTable('data_collector_card', [
            'data_collector_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'data_collector_type_id' => $this->integer()->comment('Тип автоматичного електронного засобу збору даних (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'year_build' => $this->text()->comment('Рік будівництва'),
        ]);
        $this->addCommentOnTable('data_collector_card', 'Дані про автоматичний електронний засіб збору даних');

        // Table 5.73
        $this->createTable('communication', [
            'communication_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації (згідно з [4])'),
            'tool_construction'=> $this->integer()->comment('Засоби прокладання (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'communication_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.74)'),
        ]);
        $this->addCommentOnTable('communication', 'Облікова відомість власних комунікацій');

        // Table 5.74
        $this->createTable('communication_card', [
            'communication_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації (згідно з [4])'),
            'tool_construction'=> $this->integer()->comment('Засоби прокладання (згідно з [4])'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'balance_cost' => $this->float()->comment('Балансова вартість (у тисячах гривень; з двома цифрами після коми)'),
            'defects' => $this->integer()->comment('Дефекти споруди (згідно з [4])'),
            'project_organization' => $this->text()->comment('Проектна організація'),
            'project_year' => $this->text()->comment('Рік випуску проекту'),
            'build_organization' => $this->text()->comment('Будівельна організація'),
            'year_build' => $this->text()->comment('Рік будівництва'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('communication_card', 'Дані про власну комунікацію');

        // Table 5.75
        $this->createTable('snow_protection', [
            'snow_protection_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки потенційного занесення снігом (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки потенційного занесення снігом (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'snow_protection_type_id' => $this->integer()->comment('Тип снігозахисних засобів (згідно з [4])'),
            'count' => $this->integer()->comment('Потрібна кількість снігозахисних засобів'),
        ]);
        $this->addCommentOnTable('snow_protection', 'Дані про тимчасові снігозахисні засоби');

        // Table 5.76
        $this->createTable('topography_climate', [
            'topography_climate_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'condition' => $this->string()->comment('Топографічні та кліматичні умови (pdf [3])'),
            'road_climate_zone' => $this->integer()->comment('Дорожньо-кліматична зона (згідно з Додатком Г ДБН В.2.3-4)'),
            'climate_region' => $this->integer()->comment('Дорожньо-кліматична зона (згідно з Додатком Д ДБН В.2.3-4)'),
        ]);
        $this->addCommentOnTable('topography_climate', 'Дані про топографічні та кліматичні умови');

        // Table 5.77
        $this->createTable('road_complex', [
            'road_complex_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'length' => $this->float()->comment('Довжина (у метрах; з двома цифрами після коми)'),
            'location' => $this->text()->comment('Розташування'),
            'nature_factor' => $this->integer()->comment('Природні фактори, що зумовлюють складність утримання (згідно з [4])'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('road_complex', 'Дані про ділянки дороги підвищеної складності утримання');

        // Table 5.78
        $this->createTable('rail_cross', [
            'rail_cross_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Місце перетину з залізницею (псевдогеодані)'),
            'level' => $this->integer()->comment('Рівень перетину з залізницею (згідно з [4])'),
            'rail_name' => $this->text()->comment('Назва залізниці'),
            'rail_track_count' => $this->integer()->comment('Кількість колій'),
            'rail_electricity_availability' => $this->integer()->comment('Наявність електрифікації залізниці (згідно з [4])'),
            'security_availability' => $this->integer()->comment('Наявність охорони (згідно з [4])'),
            'surface_type_id' => $this->integer()->comment('Тип покриття на переїзді (згідно з [4])'),
            'barrier_availability' => $this->integer()->comment('Наявність шлагбауму (згідно з [4])'),
            'stop_device_availability' => $this->integer()->comment('Наявність пристроїв примусової зупинки проїзду (згідно з [4])'),
            'traffic_light_availability' => $this->integer()->comment('Наявність світлофору (згідно з [4])'),
            'light_availability' => $this->integer()->comment('Наявність освітлення (згідно з [4])'),
            'train_visibility_left' => $this->float()->comment('Відстань видимості потягу ліворуч (у метрах; з двома цифрами після коми)'),
            'train_visibility_right' => $this->float()->comment('Відстань видимості потягу праворуч (у метрах; з двома цифрами після коми)'),
            'cross_angle' => $this->float()->comment('Кут перетину (в градусах; з двома цифрами після коми)'),
            'state' => $this->integer()->comment('Стан (згідно з [4])'),
            'defects' => $this->integer()->comment('Дефекти (згідно з [4])'),
            'rail_direction' => $this->text()->comment('Напрямок руху залізниці'),
            'rail_direction_vector_coords' => $this->string()->comment('Координати вектору напрямку руху (геодані)'),
            'track_first_coords' => $this->string()->comment('Координати 1-ї колії (геодані)'),
            'track_second_coords' => $this->string()->comment('Координати 2-ї колії (геодані)'),
            'track_third_coords' => $this->string()->comment('Координати 3-ї колії (геодані)'),
            'track_fourth_coords' => $this->string()->comment('Координати 4-ї колії (геодані)'),
            'rail_overpass_coords' => $this->string()->comment('Координати залізничного шляхопроводу (геодані)'),
        ]);
        $this->addCommentOnTable('rail_cross', 'Дані про ділянки перетину із залізничними коліями');

        // Table 5.79
        $this->createTable('important_object', [
            'important_object_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'position' => $this->string()->comment('Положення (псевдогеодані)'),
            'location' => $this->text()->comment('Розташування'),
            'important_object_type_id' => $this->integer()->comment('Тип об’єкту (згідно з [4])'),
            'information' => $this->text()->comment('Інформація про об\'єкт'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('important_object', 'Дані про важливі об’єкти дорожньої інфраструктури');

        // Table 5.80
        $this->createTable('communication_third', [
            'communication_third_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації (згідно з [4])'),
            'tool_construction'=> $this->integer()->comment('Засоби прокладання (згідно з [4])'),
            'communication_third_card_id' => $this->integer()->comment('Картка споруди (окрема облікова картка; табл. 5.81)'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('communication_third', 'Облікова відомість комунікацій третіх осіб');

        // Table 5.81
        $this->createTable('communication_third_card', [
            'communication_third_card_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'begin' => $this->string()->comment('Початок (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець (псевдогеодані)'),
            'communication_type_id' => $this->integer()->comment('Тип комунікації (згідно з [4])'),
            'tool_construction'=> $this->integer()->comment('Засоби прокладання (згідно з [4])'),
            'owner' => $this->text()->comment('Власник комунікації'),
            'coords' => $this->string()->comment('Координати (геодані)'),
        ]);
        $this->addCommentOnTable('communication_third_card', 'Дані про комунікації третіх осіб');

        // Table 5.82
        $this->createTable('flow', [
            'flow_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки дороги зі сталим транспортним потоком (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки дороги зі сталим транспортним потоком (псевдогеодані)'),
            'position' => $this->string()->comment('Положення пункту обліку (псевдогеодані)'),
            'car_intensity' => $this->integer()->comment('Інтенсивність руху легкових автомобілів, в т.ч. з причепами фургонів (ціле число; в автомобілях на добу)'),
            'truck_two_axle_intensity' => $this->integer()->comment('Інтенсивність руху вантажних 2-вісних автомобілів (ціле число; в автомобілях на добу)'),
            'truck_three_axle_intensity' => $this->integer()->comment('Інтенсивність руху вантажних 3-вісних автомобілів (ціле число; в автомобілях на добу)'),
            'truck_four_axle_intensity' => $this->integer()->comment('Інтенсивність руху вантажних 4-вісних автомобілів (ціле число; в автомобілях на добу)'),
            'lorry_trailer_two_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з причепами з колісними формулами 2+1, 2+2 та 2+3 (ціле число; в автомобілях на добу)'),
            'lorry_trailer_three_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з причепами з колісними формулами 3+2 та 3+3 (ціле число; в автомобілях на добу)'),
            'lorry_semitrailer_two_one_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з напівпричепами з колісною формулою 2+1 (ціле число; в автомобілях на добу)'),
            'lorry_semitrailer_two_two_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з напівпричепами з колісною формулою 2+2 (ціле число; в автомобілях на добу)'),
            'lorry_semitrailer_two_three_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з напівпричепами з колісною формулою 2+3 (ціле число; в автомобілях на добу)'),
            'lorry_semitrailer_three_one_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з напівпричепами з колісними формулами 3+1 та 3+2 (ціле число; в автомобілях на добу)'),
            'lorry_semitrailer_three_three_intensity' => $this->integer()->comment('Інтенсивність руху автопоїздів з напівпричепами з колісною формулою 3+3 (ціле число; в автомобілях на добу)'),
            'bus_intensity' => $this->integer()->comment('Інтенсивність руху автобусів (ціле число; в автомобілях на добу)'),
            'trailer_intensity' => $this->integer()->comment('Інтенсивність руху автотрейлерів низькорамних з кількістю осей 7 та більше (ціле число; в автомобілях на добу)'),
            'total_intensity' => $this->integer()->comment('Загальна інтенсивність руху (ціле число; в автомобілях на добу)'),
            'capacity' => $this->integer()->comment('Пропускна здатність (ціле число; в автомобілях на добу)'),
            'stock_coef' => $this->float()->comment('Коефіцієнт запасу (з двома цифрами після коми)'),
            'coords' => $this->string()->comment('Координати ділянки із сталим транспортним потоком (геодані)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('flow', 'Дані про транспортні потоки');

        // Table 5.83
        $this->createTable('speed_limit', [
            'speed_limit_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки дороги з однаковими умовами руху (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки дороги з однаковими умовами руху (псевдогеодані)'),
            'road_category_id' => $this->integer()->comment('Категорія дороги (згідно з [4])'),
            'forward_speed' => $this->float()->comment('Середня швидкість руху транспортного потоку в прямому напрямку (в кілометрах за годину; з двома цифрами після коми)'),
            'back_speed' => $this->float()->comment('Середня швидкість руху транспортного потоку в зворотному напрямку (в кілометрах за годину; з двома цифрами після коми)'),
            'forward_coords' => $this->string()->comment('Координати ділянки з однаковими умовами руху в прямому напрямку (геодані)'),
            'back_coords' => $this->string()->comment('Координати ділянки з однаковими умовами руху в зворотному напрямку (геодані)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (згідно з [4])'),
        ]);
        $this->addCommentOnTable('speed_limit', 'Дані про швидкісні режими руху');

        // Table 5.84
        $this->createTable('visibility_danger', [
            'visibility_danger_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки дороги з однаковими умовами руху (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки дороги з однаковими умовами руху (псевдогеодані)'),
            'road_category_id' => $this->integer()->comment('Категорія дороги (згідно з [4])'),
            'visibility_oncoming_standard' => $this->float()->comment('Нормативна відстань видимості зустрічного транспортного засобу (у метрах; згідно з 4.6 ДБН В.2.3-4)'),
            'forward_vivibility' => $this->integer()->comment('Фактична просторова видимість зустрічного транспорту в прямому напрямку руху (у метрах)'),
            'back_vivibility' => $this->integer()->comment('Фактична просторова видимість зустрічного транспорту в зворотному напрямку руху (у метрах)'),
            'safe_speed' => $this->float()->comment('Величина безпечної швидкості руху (в кілометрах за годину; з двома цифрами після коми)'),
            'conclusion' => $this->text()->comment('Висновок'),
        ]);
        $this->addCommentOnTable('visibility_danger', 'Дані про ділянки з незабезпеченою просторовою видимістю');

        // Table 5.85
        $this->createTable('road_accident', [
            'road_accident_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [4])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [5])'),
            'coords' => $this->string()->comment('Координати місця ДТП (геодані)'),
        ]);
        $this->addCommentOnTable('road_accident', 'Журнал ДТП');

        // СОУ 42.1-37641918-063_2016
        // Table А.1
        $this->createTable('road_maintenance_finance_plan', [
            'road_maintenance_finance_plan_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [3])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [3])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'finance_value' => $this->float()->comment('Величина нормативного фінансування (в тисячах гривень; з двома цифрами після коми)'),
            'inflation_coef' => $this->float()->comment('Коефіцієнт інфляції (з двома цифрами після коми)'),
            'coords' => $this->string()->comment('Координати (згідно 6.2.2.17 СОУ 42.1-37641918-122)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (табл. Б.104)'),
        ]);
        $this->addCommentOnTable('road_maintenance_finance_plan', 'Планове фінансування утримання доріг');

        // Table А.2
        $this->createTable('road_maintenance_finance_fact', [
            'road_maintenance_finance_fact_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [3])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [3])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'finance_value' => $this->float()->comment('Величина нормативного фінансування (в тисячах гривень; з двома цифрами після коми)'),
            'coords' => $this->string()->comment('Координати (згідно 6.2.2.17 СОУ 42.1-37641918-122)'),
            'date_actual' => $this->integer()->comment('Дата актуалізації (табл. Б.104)'),
        ]);
        $this->addCommentOnTable('road_maintenance_finance_fact', 'Фактичне фінансування утримання доріг');

        // Table А.3
        $this->createTable('road_maintenance_state', [
            'road_maintenance_state_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [3])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [3])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'coords' => $this->string()->comment('Координати (згідно 6.2.2.17 СОУ 42.1-37641918-122)'),
            'defect_description' => $this->text()->comment('Опис виявленого недоліку'),
            'date_add' => $this->integer()->comment('Дата створення запису (табл. Б.104)'),
            'user_add_id' => $this->integer()->comment('ЕПІН автора повідомлення про факт недоліку'),
            'photo' => $this->string()->comment('Фотографії (tiff [2])'),
            'video' => $this->string()->comment('Відео файли (avi [2])'),
            'date_remove' => $this->integer()->comment('Дата та час ліквідації виявленого недоліку (табл. Б.104)'),
            'user_remove_id' => $this->integer()->comment('ЕПІН автора повідомлення про факт ліквідації недоліку'),
        ]);
        $this->addCommentOnTable('road_maintenance_state', 'Протокол стану утримання');

        // Table А.4
        $this->createTable('critical_situation', [
            'critical_situation_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [3])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [3])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'coords' => $this->string()->comment('Координати (згідно 6.2.2.17 СОУ 42.1-37641918-122)'),
            'critical_situation_type' => $this->text()->comment('Тип критичної ситуації'),
            'critical_situation_description' => $this->text()->comment('Опис виявленої критичної ситуації'),
            'date_add' => $this->integer()->comment('Дата створення запису (табл. Б.104)'),
            'user_add_id' => $this->integer()->comment('ЕПІН автора повідомлення про факт недоліку'),
            'date_remove' => $this->integer()->comment('Дата та час ліквідації виявленого недоліку (табл. Б.104)'),
            'user_remove_id' => $this->integer()->comment('ЕПІН автора повідомлення про факт ліквідації недоліку'),
        ]);
        $this->addCommentOnTable('critical_situation', 'Протокол критичної ситуації');

        // Table А.5
        $this->createTable('repair_work', [
            'repair_work_id' => $this->primaryKey()->comment('Індекс титулу (згідно з [3])'),
            'road_name' => $this->string()->comment('Назва автомобільної дороги або під\'їзду (обходу, транспортної розв\'язки) в складі титулу (згідно з [3])'),
            'cross_section_number' => $this->integer()->comment('Номер з\'їзду транспортної розв\'язки'),
            'begin' => $this->string()->comment('Початок ділянки (псевдогеодані)'),
            'end' => $this->string()->comment('Кінець ділянки (псевдогеодані)'),
            'coords' => $this->string()->comment('Координати (згідно 6.2.2.17 СОУ 42.1-37641918-122)'),
            'repair_work_type' => $this->text()->comment('Тип ремонтних робіт'),
            'date_begin' => $this->integer()->comment('Дата початку ремонтних робіт (табл. Б.104)'),
            'date_end' => $this->integer()->comment('Дата закінчення ремонтних робіт (табл. Б.104)'),
            'project_material' => $this->string()->comment('Проектні матеріали (tiff [2])'),
            'acceptance_act' => $this->string()->comment('Акт приймання робіт (введення в експлуатацію тощо) (tiff [2])'),
        ]);
        $this->addCommentOnTable('repair_work', 'Протокол ремонтних робіт');

        // Table Б.1
        $this->createTable('horizontal_curve_direction', [
            'horizontal_curve_direction_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('horizontal_curve_direction', 'Напрямок горизонтальної кривої');
        $this->batchInsert('horizontal_curve_direction', [ 'value' ], [
            [ 'праворуч' ],
            [ 'ліворуч' ],
        ]);

        // Table Б.2
        $this->createTable('movement_direction', [
            'movement_direction_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('movement_direction', 'Напрямок руху по дорозі');
        $this->batchInsert('movement_direction', [ 'value' ], [
            [ 'в обох' ],
            [ 'прямий' ],
            [ 'зворотний' ],
        ]);

        // Table Б.3
        $this->createTable('position_according_road', [
            'position_according_road_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('position_according_road', 'Розташування відносно дороги');
        $this->batchInsert('position_according_road', [ 'value' ], [
            [ 'праворуч' ],
            [ 'ліворуч' ],
        ]);

        // Table Б.4
        $this->createTable('availability', [
            'availability_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('availability', 'Наявність/відсутність будь-чого');
        $this->batchInsert('availability', [ 'value' ], [
            [ 'так' ],
            [ 'ні' ],
        ]);

        // Table Б.5
        $this->createTable('road_type', [
            'road_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
            'definition' => $this->string(),
        ]);
        $this->addCommentOnTable('road_type', 'Індекс автомобільної дороги (стаття 8, Закон України "Про автомобільні дороги")');
        $this->batchInsert('road_type', [ 'value', 'definition' ], [
            [ 'М', 'міжнародна' ],
            [ 'Н', 'національна' ],
            [ 'Р', 'регіональна' ],
            [ 'Т', 'територіальна' ],
            [ 'О', 'обласна' ],
            [ 'С', 'районна' ],
        ]);

        // Table Б.6
        $this->createTable('road_category', [
            'road_category_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('road_category', 'Категорія автомобільної дороги (ДБН В.2.3-4, табл. 4.1)');
        $this->batchInsert('road_category', [ 'value' ], [
            [ 'І-а' ],
            [ 'І-б' ],
            [ 'ІІ' ],
            [ 'ІІІ' ],
            [ 'IV' ],
            [ 'V' ],
        ]);

        // Table Б.7
        $this->createTable('state_production', [
            'state_production_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('state_production', 'Стан виробничого об’єкту, машини або механізму');
        $this->batchInsert('state_production', [ 'value' ], [
            [ 'непрацездатний (під списання)' ],
            [ 'непрацездатний (ведуться ремонтні роботи)' ],
            [ 'непрацездатний (законсервований)' ],
            [ 'працездатний, в стані очікування' ],
            [ 'працездатний (ведеться виробництво)' ],
        ]);

        // Table Б.8
        $this->createTable('bitumen_storage_type', [
            'bitumen_storage_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('bitumen_storage_type', 'Тип бітумосховища ([4, розділ 8])');
        $this->batchInsert('bitumen_storage_type', [ 'value' ], [
            [ 'бітумосховище тимчасового типу' ],
            [ 'бітумосховище стаціонарного типу' ],
            [ 'підземне бітумосховище' ],
            [ 'напівпідземне бітумосховище' ],
            [ 'наземне бітумосховище' ],
            [ 'бітумосховище з місцевим нагріванням' ],
            [ 'бітумосховище із загальним нагріванням' ],
        ]);

        // Table Б.9
        $this->createTable('state', [
            'state_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('state', 'Стан об’єкту');
        $this->batchInsert('state', [ 'value' ], [
            [ 'працездатний' ],
            [ 'непрацездатний' ],
        ]);

        // Table Б.10
        $this->createTable('storage_type', [
            'storage_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('storage_type', 'Тип складу');
        $this->batchInsert('storage_type', [ 'value' ], [
            [ 'відкритий' ],
            [ 'закритий' ],
        ]);

        // Table Б.11
        $this->createTable('vehicle_type', [
            'vehicle_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
            'note' => $this->text()->comment('Примітки'),
        ]);
        $this->addCommentOnTable('vehicle_type', 'Тип машини (механізму)');
        $this->batchInsert('vehicle_type', [ 'value', 'note' ], [
            [ 'автобус', '[5]' ],
            [ 'автогудронатор', '' ],
            [ 'асфальтоукладач', '' ],
            [ 'бульдозер', '' ],
            [ 'вантажний автомобіль', '[5]' ],
            [ 'грейдер', '' ],
            [ 'грейдер-елеватор', '' ],
            [ 'екскаватор на гусеничному ходу', '' ],
            [ 'екскаватор на колісному ходу', '' ],
            [ 'кран підйомний на гусеничному ходу', '' ],
            [ 'кран підйомний на колісному ходу', '' ],
            [ 'навантажувач', '' ],
            [ 'машина дорожня комбінована', '' ],
            [ 'машина піскорозкидальна', '' ],
            [ 'машина снігоочисна роторна', '' ],
            [ 'причіп', '[5]' ],
            [ 'скрепер', '' ],
            [ 'трактор на гусеничному ходу', '' ],
            [ 'трактор на колісному ходу', '' ],
            [ 'фреза дорожня', '' ],
        ]);

        // Table Б.12
        $this->createTable('obstacle_up', [
            'obstacle_up_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
            'note' => $this->text()->comment('Примітки'),
        ]);
        $this->addCommentOnTable('obstacle_up', 'Назва перешкоди обмеження габариту по висоті');
        $this->batchInsert('obstacle_up', [ 'value', 'note' ], [
            [ 'портал тунелю', '[6]' ],
            [ 'міст', '[ДБН В.2.3-22]' ],
            [ 'надземний пішохідний перехід', '[7]' ],
            [ 'підвісна канатна дорога', '[8]' ],
            [ 'проїзна арка', '' ],
            [ 'дорожній знак на тросі-розтяжці', '[9]' ],
            [ 'портал-ферма', '[10]' ],
            [ 'трубопровід', '[11]' ],
            [ 'лінія зв\'язку повітряна', '[12]' ],
            [ 'ЛЕП повітряна 0,4 кВ', '[12]' ],
            [ 'ЛЕП повітряна 10 кВ', '[12]' ],
            [ 'ЛЕП повітряна 25 кВ', '[12]' ],
            [ 'ЛЕП повітряна 35 кВ', '[12]' ],
            [ 'ЛЕП повітряна 110 кВ', '[12]' ],
            [ 'ЛЕП повітряна 150 кВ', '[12]' ],
            [ 'ЛЕП повітряна 330 кВ', '[12]' ],
        ]);

        // Table Б.13
        $this->createTable('land_soil', [
            'land_soil_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('land_soil', 'Ґрунт земляного полотна (6.2 ДБН В.2.3-4)');
        $this->batchInsert('land_soil', [ 'value' ], [
            [ 'глина' ],
            [ 'глина жирна' ],
            [ 'глина піщаниста' ],
            [ 'глина пилувата' ],
            [ 'глина напівжирна' ],
            [ 'глинистий сланець' ],
            [ 'гравій' ],
            [ 'ґрунт галечниковий' ],
            [ 'ґрунт галечниковий із суглинистим заповнювачем' ],
            [ 'ґрунт гравійний із суглинистим заповнювачем' ],
            [ 'ґрунт з жорствою' ],
            [ 'ґрунт щебенистий із суглинистим заповнювачем' ],
            [ 'каштанові землі вологі' ],
            [ 'каштанові землі змішані' ],
            [ 'лес вологий' ],
            [ 'лес затверділий' ],
            [ 'лес злежаний' ],
            [ 'лес рихлий' ],
            [ 'мергель' ],
            [ 'пісок крупний' ],
            [ 'пісок дрібний' ],
            [ 'пісок пилуватий' ],
            [ 'сланець глинистий' ],
            [ 'солончак' ],
            [ 'суглинок' ],
            [ 'суглинок важкий' ],
            [ 'суглинок важкий з галькою' ],
            [ 'суглинок легкий' ],
            [ 'суглинок легкий пилуватий' ],
            [ 'суглинок супіщаний' ],
            [ 'суглинок щебенистий' ],
            [ 'супісок' ],
            [ 'супісок важкий пилуватий' ],
            [ 'супісок легкий крупний' ],
            [ 'супісок пилуватий' ],
            [ 'торф' ],
            [ 'піщаник' ],
            [ 'піщаник вивітрілий' ],
            [ 'вапняк' ],
            [ 'вапняк вивітрілий' ],
            [ 'жорства' ],
        ]);

        // Table Б.14
        $this->createTable('state_common', [
            'state_common_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('state_common', 'Стан простого об’єкту');
        $this->batchInsert('state_common', [ 'value' ], [
            [ 'добрий' ],
            [ 'задовільний' ],
            [ 'незадовільний' ],
            [ 'непрацездатний' ],
            [ 'аварійний' ],
        ]);

        // Table Б.15
        $this->createTable('ventilation_type', [
            'ventilation_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('ventilation_type', 'Тип вентиляції тунелів та підземних пішохідних переходів');
        $this->batchInsert('ventilation_type', [ 'value' ], [
            [ 'примусова' ],
            [ 'природня' ],
        ]);

        // Table Б.16
        $this->createTable('light_type', [
            'light_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('light_type', 'Тип освітлення тунелів та підземних пішохідних переходів');
        $this->batchInsert('light_type', [ 'value' ], [
            [ 'штучне' ],
            [ 'природне' ],
        ]);

        // Table Б.17
        $this->createTable('antiseismic_type', [
            'antiseismic_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('antiseismic_type', 'Тип антисейсмічних пристроїв (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('antiseismic_type', [ 'value' ], [
            [ 'відсутній' ],
            [ 'комбінації повздовжніх і поперечних обмежувачів' ],
            [ 'комбіноване використання спеціальних опорних частин з обмежувачами переміщень' ],
            [ 'обмежувачі повздовжніх переміщень прогонових будов' ],
            [ 'обмежувачі поперечних переміщень прогонових будов на опорах' ],
            [ 'спеціальні антисейсмічні опорні частини' ],
        ]);

        // Table Б.18
        $this->createTable('communication_type', [
            'communication_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('communication_type', 'Тип комунікації, що перепускаються штучною спорудою');
        $this->batchInsert('communication_type', [ 'value' ], [
            [ 'відсутня' ],
            [ 'водогін' ],
            [ 'кабель електричний' ],
            [ 'кабель зв’язку' ],
        ]);

        // Table Б.19
        $this->createTable('header_purpose', [
            'header_purpose_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('header_purpose', 'Призначення оголовка (портала)');
        $this->batchInsert('header_purpose', [ 'value' ], [
            [ 'вхідний' ],
            [ 'вихідний' ],
        ]);

        // Table Б.20
        $this->createTable('header_type', [
            'header_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('header_type', 'Тип оголовка (портала) (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('header_type', [ 'value' ], [
            [ 'портальний' ],
            [ 'розтрубний' ],
            [ 'комірцевий' ],
            [ 'коридорний прямий' ],
            [ 'коридорний з сходовими клітинами' ],
        ]);

        // Table Б.21
        $this->createTable('body_material', [
            'body_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('body_material', 'Матеріали тіла штучних споруд (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('body_material', [ 'value' ], [
            [ 'бетон' ],
            [ 'бетон і бутобетон' ],
            [ 'бетон і залізобетон' ],
            [ 'бетон і кам`яна кладка' ],
            [ 'бутобетон' ],
            [ 'бутобетон, бетон,залізобетон' ],
            [ 'гофрований метал' ],
            [ 'деревина' ],
            [ 'залізобетон' ],
            [ 'кам`яна (цегляна) кладка і залізобетон' ],
            [ 'кам`яна кладка' ],
            [ 'метал' ],
            [ 'металеві тюбінги' ],
            [ 'попередньонапружений залізобетон' ],
            [ 'сталезалізобетон' ],
            [ 'цегляна кладка' ],
        ]);

        // Table Б.22
        $this->createTable('foundation_material', [
            'foundation_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('foundation_material', 'Матеріали тіла штучних споруд (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('foundation_material', [ 'value' ], [
            [ 'бетон' ],
            [ 'бетон і бутобетон' ],
            [ 'бетон і залізобетон' ],
            [ 'бетон і кам`яна кладка' ],
            [ 'бутобетон' ],
            [ 'бутобетон, бетон,залізобетон' ],
            [ 'гофрований метал' ],
            [ 'деревина' ],
            [ 'залізобетон' ],
            [ 'кам`яна (цегляна) кладка і залізобетон' ],
            [ 'кам`яна кладка' ],
            [ 'метал' ],
            [ 'попередньонапружений залізобетон' ],
            [ 'сталезалізобетон' ],
            [ 'цегляна кладка' ],
        ]);

        // Table Б.23
        $this->createTable('basement_material', [
            'basement_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('basement_material', 'Матеріали основи під фундамент (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('basement_material', [ 'value' ], [
            [ 'піщано-гравійна суміш' ],
            [ 'пісок' ],
            [ 'щебінь' ],
        ]);

        // Table Б.24
        $this->createTable('fortified_slope_material', [
            'fortified_slope_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('fortified_slope_material', 'Матеріали укріплення укосів земляного полотна на штучних спорудах (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('fortified_slope_material', [ 'value' ], [
            [ 'без укріплення' ],
            [ 'бетон' ],
            [ 'бетонна обрешітка із засипкою щебенем' ],
            [ 'бутобетон' ],
            [ 'габіони' ],
            [ 'залізобетонна решітка, монолітний бетон' ],
            [ 'залізобетонні плити' ],
            [ 'збірні бетонні блоки' ],
            [ 'кам`яний накид' ],
            [ 'матрац Рено' ],
            [ 'монолітний бетон' ],
            [ 'підпірна стінка' ],
            [ 'посів трав' ],
        ]);

        // Table Б.25
        $this->createTable('body_type', [
            'body_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('body_type', 'Типи форми тіла штучних споруд (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('body_type', [ 'value' ], [
            [ 'арочна' ],
            [ 'закритий лоток овоідального типу' ],
            [ 'закритий лоток трапецевидного типу' ],
            [ 'кругла' ],
            [ 'овальна' ],
            [ 'прямокутна' ],
            [ 'склепінчаста' ],
        ]);

        // Table Б.26
        $this->createTable('span_scheme', [
            'span_scheme_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('span_scheme', 'Статичні схеми прогонових будов (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('span_scheme', [ 'value' ], [
            [ 'арочна' ],
            [ 'балочна консольна з підвісками' ],
            [ 'балочна нерозрізна' ],
            [ 'балочна однопрогонова з подвійною консольною балкою' ],
            [ 'балочна розрізна' ],
            [ 'балочно-консольна' ],
            [ 'вантова' ],
            [ 'висяча' ],
            [ 'комбінована' ],
            [ 'консольно-підвісна' ],
            [ 'рамна' ],
            [ 'рамно-консольна' ],
        ]);

        // Table Б.27
        $this->createTable('span_type', [
            'span_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('span_type', 'Типи конструкцій прогонових будов (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('span_type', [ 'value' ], [
            [ 'арочна зовнішньо безрозпірна з проїздом по низу двотаврового перерізу' ],
            [ 'арочна зовнішньо безрозпірна з проїздом посередині двотаврогого перерізу' ],
            [ 'арочна зовнішньо безрозпірна з проїздом посередині коробчатого перерізу' ],
            [ 'арочна зовнішньо безрозпірна з проїздом посередині прямокутного перерізу' ],
            [ 'арочна зовнішньо розпірна з проїздом посередині коробчатого перерізу' ],
            [ 'арочна зовнішньо розпірна з проїздом по верху двутаврового перерізу' ],
            [ 'арочна зовнішньо розпірна з проїздом по верху прямокутного перерізу' ],
            [ 'арочна зовнішньо розпірна з проїздом по верху у вигляді спарених двотаврів' ],
            [ 'арочна зовнішньо розпірна з проїздом посередині прямокутного перерізу' ],
            [ 'арочна комбінована консольна' ],
            [ 'арочна комбінована нерозрізна' ],
            [ 'арочна комбінована посилена балкою жорсткості' ],
            [ 'арочна комбінована посилена ланцюгом' ],
            [ 'арочна система із затяжкою в комбінації з консольними балками' ],
            [ 'арочна трьохшарнірна' ],
            [ 'висяча вантова ферма гнучка променева система' ],
            [ 'висяча вантова ферма гнучка система Жискляра' ],
            [ 'висяча вантова ферма гнучка система Рабіновича' ],
            [ 'висяча вантова ферма гнучка система Росновського' ],
            [ 'висяча вантова ферма жорстка з паралельними поясами' ],
            [ 'висяча вантова ферма жорстка з серповидним обрисом' ],
            [ 'висяча вантова ферма комбінована з наскрізною балкою жорсткості з паралельними поясами' ],
            [ 'висяча вантова ферма комбінована з наскрізною балкою жорсткості змінної висоти' ],
            [ 'висяча вантова ферма комбінована з суцільної балкою жорсткості коробчастого перерізу з приопорним потовщенням' ],
            [ 'висяча вантова ферма комбінована з суцільної балкою жорсткості коробчатого перерізу з паралельними поясами' ],
            [ 'висяча вантова ферма комбінована з суцільної балкою жорсткості таврового перерізу з паралельними поясами' ],
            [ 'висяча гнучка кабельна' ],
            [ 'висяча гнучка комбінована з поздовжньою балкою в рівні проїзної частини' ],
            [ 'висяча гнучка комбінована з поздовжньою фермою в рівні проїзної частини (перилами)' ],
            [ 'висяча гнучка ланцюгова' ],
            [ 'дерев\'яна двохпідкосна' ],
            [ 'дерев\'яна з двохярусними прогонами' ],
            [ 'дерев\'яна з одноярусними прогонами з проїздом на баласті' ],
            [ 'дерев\'яна з одноярусними прогонами з проїздом по поперечинах' ],
            [ 'дерев\'яна однопідкосна' ],
            [ 'дерев\'яна пакетна з гнучкими шпонками' ],
            [ 'дерев\'яна пакетна на дубових шпонках' ],
            [ 'дерев\'яна ферма Гау-Журавського' ],
            [ 'дерев\'яна ферма дощата' ],
            [ 'дерев\'яна ферма хрестова' ],
            [ 'жорстка рамна' ],
            [ 'збірна ребриста бездіафрагмова з таврових балок з каркасною арматури, випуск 56доп' ],
            [ 'збірна ребриста з пучкової арматури випуск 122-62' ],
            [ 'збірна ребриста з Т-подібних балок з каркасною арматурою вип.56' ],
            [ 'збірна ребриста струнобетонна ВТП-15' ],
            [ 'збірна ребриста струнобетонна ВТП-16' ],
            [ 'збірна ребриста струнобетонна типовий проект 149-62 Союздорпроект' ],
            [ 'коробчаста багатоконтурна з вигнутою формою зовнішніх стінок' ],
            [ 'коробчаста багатоконтурна з опуклою формою нижньої плити' ],
            [ 'коробчаста багатоконтурна з похилими гранями' ],
            [ 'коробчаста з криволінійними стінками' ],
            [ 'коробчаста одно-контурна з вигнутою формою зовнішніх стінок' ],
            [ 'коробчаста одно-контурна з опуклою формою нижньої плити' ],
            [ 'коробчаста одно-контурна з похилими гранями' ],
            [ 'одностоякова рама' ],
            [ 'плитна з поздовжніми пустотами круглої форми' ],
            [ 'плитна з поздовжніми пустотами прямокутної форми' ],
            [ 'плитна з поздовжніми пустотами циліндричної форми' ],
            [ 'плитна з поперечними пустотами' ],
            [ 'плитна збірна двохпустотна з напруженою арматурою, сб. ВТП-21' ],
            [ 'плитна збірна з прогонових плит, ВТП-16' ],
            [ 'плитна збірна струнобетонна з плит суцільного перерізу' ],
            [ 'плитна змінної висоти в поздовжньому перерізі' ],
            [ 'плитна змінної висоти в поперечному перерізі' ],
            [ 'плитна змінної висоти в поперечному та поздовжньому перерізах' ],
            [ 'плитна суцільного перерізу' ],
            [ 'плитна типова збірна Белгіпродор випуск 5-04-145' ],
            [ 'плитно-ребриста з діафрагмами з ребрами таврового перерізу' ],
            [ 'плитно-ребриста конструкція' ],
            [ 'рама V-образного типу з окремими нахиленими стоянами' ],
            [ 'рама V-образного типу на кінцях сполучені шарніром' ],
            [ 'рама з двома шарнірними нахиленими стоянами' ],
            [ 'рама з нахиленими стоянами' ],
            [ 'рама з шарнірними одиночними нахиленими стоянами' ],
            [ 'рами з жорстким закріпленням' ],
            [ 'рами з шарнірним закріпленням' ],
            [ 'ребриста бездіафрагмова з ребрами V-подібного перерізу' ],
            [ 'ребриста бездіафрагмова з ребрами двотаврового перерізу' ],
            [ 'ребриста бездіафрагмова з ребрами П-подібного перерізу' ],
            [ 'ребриста бездіафрагмова з ребрами таврового перерізу' ],
            [ 'ребриста бездіафрагмова криволінійного обрису (змінної висоти в приопорних зонах)' ],
            [ 'ребриста з діафрагмами з ребрами двотаврового перерізу з ломаним обрисом поясів' ],
            [ 'ребриста з діафрагмами з ребрами двотаврого перерізу з паралельними поясами' ],
            [ 'ребриста з діафрагмами з ребрами П-подібного перерізу' ],
            [ 'ребриста з діафрагмами з ребрами таврового перерізу' ],
            [ 'ребриста з діафрагмами з ребрами таврового перерізу з криволійним обрисом поясів' ],
            [ 'ребриста з діафрагмами криволінійного обрису (змінної висоти в приопорних зонах)' ],
            [ 'ребриста із збірних уніфікованих попередньо-напружених балок' ],
            [ 'склепіння несиметричне' ],
            [ 'склепіння симетричне' ],
            [ 'Т-подібна рамна з омоноліченими кінцями консоль між собою' ],
            [ 'Т-подібна рамна шарнірно сполучена у середині прогонів' ],
            [ 'ферма з проїздом по низу з полігональними поясами з трикутними решітками із шпренгелями' ],
            [ 'ферма з проїздом по верху з паралельними поясами багаторешітчата' ],
            [ 'ферма з проїздом по верху з паралельними поясами двохрешітчата' ],
            [ 'ферма з проїздом по верху з паралельними поясами з трикутними решітками' ],
            [ 'ферма з проїздом по верху з полігональними поясами з трикутними решітками' ],
            [ 'ферма з проїздом по низу з паралельними поясами з трикутними решітками із шпренгелями' ],
            [ 'ферма з проїздом по низу з полігональними поясами двохрешітчата' ],
            [ 'ферма арочна з горизонтальним верхнім поясом з проїздом по верху' ],
            [ 'ферма з проїздом по верху арочна з паралельними поясами із розкосою решіткою' ],
            [ 'ферма з проїздом по верху арочна з паралельними поясами із трикутною решіткою' ],
            [ 'ферма з проїздом по верху арочна серповидного обрису' ],
            [ 'ферма з проїздом по верху з паралельними поясами багаторозкісна' ],
            [ 'ферма з проїздом по верху з паралельними поясами з напіврозкісними решітками' ],
            [ 'ферма з проїздом по верху з паралельними поясами з розкісними решітками' ],
            [ 'ферма з проїздом по верху з паралельними поясами з ромбоподібними решітками' ],
            [ 'ферма з проїздом по верху з паралельними поясами з трикутними решітками із шпренгелями' ],
            [ 'ферма з проїздом по верху з паралельними поясами з хрестовими решітками' ],
            [ 'ферма з проїздом по верху з паралельними поясами системи Скугорева' ],
            [ 'ферма з проїздом по верху з полігональними поясами двохрешітчата' ],
            [ 'ферма з проїздом по верху з полігональними поясами з напіврозкісними решітками' ],
            [ 'ферма з проїздом по верху з полігональними поясами з розкісними решітками' ],
            [ 'ферма з проїздом по верху з полігональними поясами з трикутними решітками із шпренгелями' ],
            [ 'ферма з проїздом по верху з полігональними поясами з хрестовими решітками' ],
            [ 'ферма з проїздом по низу арочна зі збільшеною висотою у опор' ],
            [ 'ферма з проїздом по низу арочна зі збільшеною висотою у чвертях прольоту' ],
            [ 'ферма з проїздом по низу арочна портальна з розкосою решіткою' ],
            [ 'ферма з проїздом по низу арочна портальна з трикутною решіткою' ],
            [ 'ферма з проїздом по низу з паралельними поясами багаторозкісна' ],
            [ 'ферма з проїздом по низу з паралельними поясами двохрешітчата' ],
            [ 'ферма з проїздом по низу з паралельними поясами з багаторешітчата' ],
            [ 'ферма з проїздом по низу з паралельними поясами з напіврозкісними решітками' ],
            [ 'ферма з проїздом по низу з паралельними поясами з розкісними решітками' ],
            [ 'ферма з проїздом по низу з паралельними поясами з трикутними решітками' ],
            [ 'ферма з проїздом по низу з паралельними поясами з хрестовими решітками' ],
            [ 'ферма з проїздом по низу з полігональними поясами багаторозкісна' ],
            [ 'ферма з проїздом по низу з полігональними поясами з напіврозкісними решітками' ],
            [ 'ферма з проїздом по низу з полігональними поясами з розкісними решітками' ],
            [ 'ферма з проїздом по низу з полігональними поясами з трикутними решітками' ],
            [ 'ферма з проїздом по низу з полігональними поясами з хрестовими решітками' ],
            [ 'ферма з проїздом по низу серповидного обрису з суцільною стінкою' ],
            [ 'ферма з проїздом посередині серповидного обрису' ],
            [ 'ферма з паралельними поясами з ромбоподібними решітками з проїздом по низу' ],
        ]);

        // Table Б.28
        $this->createTable('load_project', [
            'load_project_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('load_project', 'Проектне навантаження (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('load_project', [ 'value' ], [
            [ 'А11, НК80' ],
            [ 'А14, НК80' ],
            [ 'А15, НК100' ],
            [ 'А15, НК80' ],
            [ 'Н8, НГ30' ],
            [ 'Н8, НГ60' ],
            [ 'Н10, НГ60' ],
            [ 'H13, НГ30' ],
            [ 'Н13, НГ60' ],
            [ 'Н18, НК80' ],
            [ 'Н30, НК80' ],
            [ 'С10' ],
            [ 'С14' ],
            [ 'від пішоходів 400 кг/м 2' ],
            [ 'від потоку води' ],
        ]);

        // Table Б.29
        $this->createTable('bearing_moving_type', [
            'bearing_moving_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('bearing_moving_type', 'Типи рухомих опорних частин (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('bearing_moving_type', [ 'value' ], [
            [ 'валкова' ],
            [ 'комбінована' ],
            [ 'листова з металу' ],
            [ 'плоска' ],
            [ 'поліуретанова' ],
            [ 'гумова' ],
            [ 'руберойдова' ],
            [ 'тангенціальна' ],
            [ 'гумово-металева' ],
            [ 'секторна' ],
        ]);

        // Table Б.30
        $this->createTable('bearing_not_moving_type', [
            'bearing_not_moving_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('bearing_not_moving_type', 'Типи нерухомих опорних частин (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('bearing_not_moving_type', [ 'value' ], [
            [ 'комбінована' ],
            [ 'листова з металу' ],
            [ 'плоска' ],
            [ 'поліуретанова' ],
            [ 'гумова' ],
            [ 'руберойдова' ],
            [ 'тангенціальна' ],
            [ 'гумово-металева' ],
        ]);

        // Table Б.31
        $this->createTable('cross_joint_type', [
            'cross_joint_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('cross_joint_type', 'Спосіб поперечного об\'єднання прогонових будов (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('cross_joint_type', [ 'value' ], [
            [ 'шпонковий' ],
        ]);

        // Table Б.32
        $this->createTable('pillar_type', [
            'pillar_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('pillar_type', 'Типи конструкцій опор (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('pillar_type', [ 'value' ], [
            [ 'А-подібний пілон' ],
            [ 'Н-подібний пілон' ],
            [ 'берегова обсипна стійкова дворядна' ],
            [ 'берегова аркова масивна опора' ],
            [ 'берегова лежнева кутового профілю на гравійній подушці' ],
            [ 'берегова лежнева кутового профілю на щебеневій подушці' ],
            [ 'берегова лежнева плоска на гравійній подушці' ],
            [ 'берегова лежнева плоска на піщаній подушці' ],
            [ 'берегова лежнева плоска на щебеневій подушці' ],
            [ 'берегова лежнева кутового профілю на піщаній подушці' ],
            [ 'берегова масивна з боковими відкрилками' ],
            [ 'берегова масивна з оберненими стінками' ],
            [ 'берегова масивна ребриста' ],
            [ 'берегова масивна обсипна з боковими відкрилками' ],
            [ 'берегова масивна обсипна з прорізом' ],
            [ 'берегова масивна обсипна монолітна' ],
            [ 'берегова масивна обсипна монолітна полегшена' ],
            [ 'берегова масивна обсипна монолітна полегшена з боковими відкрилками' ],
            [ 'берегова масивна обсипна пальова-стовпчаста' ],
            [ 'берегова масивна обсипна стовпчаста' ],
            [ 'берегова масивна обсипна стоякова' ],
            [ 'берегова масивна опора-стінка' ],
            [ 'берегова масивна стовпчаста обсипна козлового типу' ],
            [ 'берегова масивна тонка стінка' ],
            [ 'берегова обсипна арочна опора' ],
            [ 'берегова обсипна арочна опора коробчастого типу' ],
            [ 'берегова обсипна пальова дворядна' ],
            [ 'берегова обсипна пальова козлового типу' ],
            [ 'берегова обсипна пальова однорядна' ],
            [ 'берегова опора з боковим прорізом' ],
            [ 'берегова опора коробчастого типу' ],
            [ 'берегова пальова двохрядна' ],
            [ 'берегова пальова двохрядна із забірною стінкою' ],
            [ 'берегова пальова однорядна із забірною стінкою' ],
            [ 'берегова полегшена опора-стінка (сист. Cловінського)' ],
            [ 'берегова стовпчаста V- подібна' ],
            [ 'дерев\'яна M-подібна' ],
            [ 'дерев\'яна баштова' ],
            [ 'дерев\'яна з похилими палями' ],
            [ 'дерев\'яна з укосинами' ],
            [ 'дерев\'яна із двох напівбиків' ],
            [ 'дерев\'яна із двох напівбиків з похилими стояками' ],
            [ 'дерев\'яна із двох напівбиків з укосинами' ],
            [ 'дерев\'яна лежнева на гравійній подушці' ],
            [ 'дерев\'яна лежнева на піщаній подушці' ],
            [ 'дерев\'яна лежнева на щебеневій подушці' ],
            [ 'дерев\'яна пальова' ],
            [ 'дерев\'яна рамно-лежнева' ],
            [ 'дерев\'яна рамнопальова' ],
            [ 'дерев\'яна ряжева' ],
            [ 'дерев\'яний рамно-пальовий бик' ],
            [ 'опора рамно-нерозрізної системи' ],
            [ 'проміжна одностовпчаста прямокутного перерізу' ],
            [ 'проміжна пальова стійкова однорядна' ],
            [ 'проміжна "масивний бик"' ],
            [ 'проміжна двостійкова' ],
            [ 'проміжна двостійкова з рамною надбудовою' ],
            [ 'проміжна двостійкова із паль-оболонок' ],
            [ 'проміжна двостовпчаста' ],
            [ 'проміжна двостовпчаста телескопічна' ],
            [ 'проміжна з пальових-стовпів' ],
            [ 'проміжна масивна "двохярусний бик"' ],
            [ 'проміжна масивна арочна' ],
            [ 'проміжна масивна двостовпчаста' ],
            [ 'проміжна масивна із вертикальних паль-оболонок' ],
            [ 'проміжна масивна із похилих паль-оболонок' ],
            [ 'проміжна масивна несиметрична арочна опора' ],
            [ 'проміжна масивна опора-стінка' ],
            [ 'проміжна масивна полегшена опора' ],
            [ 'проміжна масивна полегшений бик з консолями' ],
            [ 'проміжна масивна стоякова козлова' ],
            [ 'проміжна масивна телескопічна' ],
            [ 'проміжна монолітна рамна з вертикальними стійками' ],
            [ 'проміжна монолітна рамна з похилими стійками' ],
            [ 'проміжна одностовпчаста' ],
            [ 'проміжна опора консольно-підвісної системи' ],
            [ 'проміжна опора, що хитається' ],
            [ 'проміжна опора-стінка' ],
            [ 'проміжна пальова двохрядна' ],
            [ 'проміжна пальова двохрядна з насадками' ],
            [ 'проміжна пальова двохрядна із захисною обробкою' ],
            [ 'проміжна пальова однорядна' ],
            [ 'проміжна пальова однорядна з насадками' ],
            [ 'проміжна пальова однорядна із захисною обробкою' ],
            [ 'проміжна пальова однорядна об\'єднана монолітним бетоном із захисними з/б плитами' ],
            [ 'проміжна пальова стійкова двохрядна' ],
            [ 'проміжна пальова стійкова однорядна' ],
            [ 'проміжна полегшена арочна опора' ],
            [ 'проміжна стійкова металева зі стійками двотаврового перерізу' ],
            [ 'проміжна стійкова металева зі стійками коробчастого перерізу' ],
            [ 'проміжна стовпчаста' ],
            [ 'проміжна стовпчаста V-подібна' ],
            [ 'проміжна стовпчаста на опускних колодязях' ],
            [ 'проміжна стовпчаста телескопічна' ],
            [ 'проміжна трьохстовпчата з двохконсольним ригелем' ],
            [ 'проміжна чотирьохстоякова рамна опора' ],
        ]);

        // Table Б.33
        $this->createTable('pillar_body_material', [
            'pillar_body_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('pillar_body_material', 'Матеріали тіла опор (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('pillar_body_material', [ 'value' ], [
            [ 'збірний залізобетон' ],
            [ 'монолітний залізобетон' ],
            [ 'металева оболонка з заповненням монолітним бетоном' ],
            [ 'бутобетон' ],
            [ 'кам\'яна кладка' ],
            [ 'деревина (кругляк)' ],
            [ 'деревина (клеєна)' ],
            [ 'різнорідний' ],
        ]);

        // Table Б.34
        $this->createTable('pillar_foundation_type', [
            'pillar_foundation_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('pillar_foundation_type', 'Типи фундаментів опор (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('pillar_foundation_type', [ 'value' ], [
            [ 'мілкого закладання на природній основі' ],
            [ 'мілкого закладання на штучній основі' ],
            [ 'масивний глибокого закладання на природній основі' ],
            [ 'масивний глибокого закладання на штучній основі' ],
            [ 'стовпчастий вертикальний з повним заповненням' ],
            [ 'стовпчастий вертикальний з заповненням у вигляді потовщення стін/низький' ],
            [ 'стовпчастий вертикальний з заповненням у вигляді бетонних пробок' ],
            [ 'стовпчастий вертикальний з заповненням у вигляді діафрагм' ],
            [ 'стовпчастий вертикальний з ґрунтовим ядром' ],
            [ 'стовпчастий похилий з повним заповненням' ],
            [ 'стовпчастий похилий з заповненням у вигляді потовщення стін' ],
            [ 'стовпчастий похилий з заповненням у вигляді бетонних пробок' ],
            [ 'стовпчастий похилий з заповненням у вигляді діафрагм' ],
            [ 'стовпчастий похилий з ґрунтовим ядром' ],
            [ 'пальовий з низьким ростверком однорядний на забивних палях' ],
            [ 'пальовий однорядний з низьким ростверком на пустотілих палях' ],
            [ 'пальовий однорядний з низьким ростверком на гвинтових палях суцільного перерізу' ],
            [ 'пальовий однорядний з низьким ростверком на гвинтових палях прямокутного перерізу' ],
            [ 'пальовий однорядний з низьким ростверком на гвинтових палях круглого перерізу' ],
            [ 'пальовий однорядний з низьким ростверком на дрібно гвинтових палях' ],
            [ 'пальовий однорядний з низьким ростверком на палях змішаного типу' ],
            [ 'пальовий однорядний з низьким ростверком на набивних палях з рифленою поверхнею' ],
            [ 'пальовий однорядний з низьким ростверком на набивних палях з п`ятою розширення нижнього кінця палі' ],
            [ 'пальовий однорядний з низьким ростверком на палях виделково-кореневої форми' ],
            [ 'пальовий однорядний з низьким ростверком на палях багато виделкової кореневої форми' ],
            [ 'пальовий однорядний з низьким ростверком на палях фігурної форми з розширенням в середній частині' ],
            [ 'пальовий однорядний з низьким ростверком на палях фігурної форми з розширенням в різних місцях по висоті палі' ],
            [ 'пальовий однорядний з низьким ростверком на бурових палях-стовпах' ],
            [ 'пальовий однорядний з низьким ростверком на буро набивних суцільного перерізу' ],
            [ 'пальовий однорядний з низьким ростверком на бурових палях' ],
            [ 'пальовий однорядний з низьким ростверком на буро набивних суцільного перерізу з розширеннями' ],
            [ 'пальовий однорядний з низьким ростверком на буро опускних палях з камуфлетною п`ятою' ],
            [ 'пальовий однорядний з низьким ростверком на буро набивних порожнистих круглих палях' ],
            [ 'пальовий однорядний з низьким ростверком на буро набивних камуфлетних палях' ],
            [ 'пальовий однорядний з низьким ростверком на буро набивних з ущільненим вибоєм' ],
            [ 'пальовий однорядний з низьким ростверком на буро ін’єкційних палях' ],
            [ 'вертикальний опускний колодязь' ],
            [ 'похилий опускний колодязь' ],
            [ 'східчастий опускний колодязь' ],
            [ 'кесон' ],
            [ 'пальовий багаторядний з низьким ростверком на пустотілих палях' ],
            [ 'пальовий багаторядний з низьким ростверком на гвинтових палях суцільного перерізу' ],
            [ 'пальовий однорядний з високим ростверком на гвинтових палях суцільного перерізу' ],
            [ 'пальовий багаторядний з високим ростверком на гвинтових палях суцільного перерізу' ],
            [ 'пальовий з високим ростверком однорядний на забивних палях' ],
            [ 'пальовий з низьким ростверком багаторядний на забивних палях' ],
            [ 'пальовий з високим ростверком багаторядний на забивних палях' ],
            [ 'пальовий багаторядний з низьким ростверком на гвинтових палях круглого перерізу' ],
            [ 'пальовий однорядний з високим ростверком на гвинтових палях круглого перерізу' ],
            [ 'пальовий багаторядний з високим ростверком на гвинтових палях круглого перерізу' ],
            [ 'пальовий багаторядний з низьким ростверком на гвинтових палях прямокутного перерізу' ],
            [ 'пальовий однорядний з високим ростверком на гвинтових палях прямокутного перерізу' ],
            [ 'пальовий багаторядний з високим ростверком на гвинтових палях прямокутного перерізу' ],
            [ 'пальовий багаторядний з низьким ростверком на дрібно гвинтових палях' ],
            [ 'пальовий однорядний з високим ростверком на дрібно гвинтових палях' ],
            [ 'пальовий багаторядний з високим ростверком на дрібно гвинтових палях' ],
            [ 'пальовий багаторядний з низьким ростверком на палях змішаного типу' ],
            [ 'пальовий однорядний з високим ростверком на палях змішаного типу' ],
            [ 'пальовий багаторядний з високим ростверком на палях змішаного типу' ],
            [ 'пальовий однорядний' ],
            [ 'пальовий багаторядний' ],
        ]);

        // Table Б.35
        $this->createTable('icebreaker_type', [
            'icebreaker_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('icebreaker_type', 'Тип льодорізів (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('icebreaker_type', [ 'value' ], [
            [ 'аванпостний' ],
            [ 'передопорний' ],
        ]);

        // Table Б.36
        $this->createTable('icebreaker_material', [
            'icebreaker_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('icebreaker_material', 'Матеріал льодорізів (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('icebreaker_material', [ 'value' ], [
            [ 'збірний залізобетон' ],
            [ 'монолітний залізобетон' ],
            [ 'сталебетон' ],
            [ 'кам\'яна кладка' ],
            [ 'метал' ],
            [ 'дерево (кругляк)' ],
            [ 'дерево (клеєне)' ],
            [ 'різнорідний' ],
        ]);

        // Table Б.37
        $this->createTable('wall_material', [
            'wall_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('wall_material', 'Матеріал стін будівлі (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('wall_material', [ 'value' ], [
            [ 'збірний залізобетон' ],
            [ 'монолітний залізобетон' ],
            [ 'цегляна кладка' ],
            [ 'кам\'яна кладка' ],
            [ 'дерево кругле' ],
            [ 'дерев\'яний каркас з обшивкою' ],
            [ 'метал – зварена арматура' ],
            [ 'метал профільований' ],
            [ 'метал – зварена рама з заскленням' ],
        ]);

        // Table Б.38
        $this->createTable('roof_material', [
            'roof_material_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('roof_material', 'Матеріал даху будівлі (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('roof_material', [ 'value' ], [
            [ 'збірний залізобетон' ],
            [ 'дерев\'яний каркас з обшивкою' ],
            [ 'дерев\'яний каркас з обшивкою та черепицею' ],
            [ 'дерев\'яний каркас з обшивкою та металевою черепицею' ],
            [ 'дерев\'яний каркас з обшивкою та гофрованим шифером' ],
            [ 'дерев\'яний каркас з обшивкою та гофрованою пластмасою' ],
            [ 'металевий каркас з заскленням' ],
            [ 'комірчата пластмаса (марлон)' ],
        ]);

        // Table Б.39
        $this->createTable('drainage_type', [
            'drainage_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('drainage_type', 'Типи водовідведення');
        $this->batchInsert('drainage_type', [ 'value' ], [
            [ 'за рахунок поперечних та повздовжніх похилі проїзжої частини' ],
            [ 'з використанням водовідвідних трубок' ],
            [ 'з використанням зливової каналізації відкритого типу' ],
            [ 'з використанням зливової каналізації закритого типу' ],
        ]);

        // Table Б.40
        $this->createTable('span_project', [
            'span_project_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('span_project', 'Типові проекти прогонових будов (ДБН В.2.3-22, [13, 14, 26, 28])');
        $this->batchInsert('span_project', [ 'value' ], [
            [ 'індивідуальний' ],
            [ '3.503.1-102' ],
            [ '3.503.1-75' ],
            [ '3.503-29' ],
            [ '932-1-КЖИ' ],
            [ 'ВБК 32-95' ],
            [ 'Вип. 137 "Союздорпроект"' ],
            [ 'Випуск 3.503-23' ],
            [ 'Випуск 122-63' ],
            [ 'Випуск 149-62' ],
            [ 'Випуск 167' ],
            [ 'Випуск 29' ],
            [ 'Випуск 3.0503-12' ],
            [ 'Випуск 3.503.1-53' ],
            [ 'Випуск 3.503.1-58' ],
            [ 'Випуск 3.503.1-79' ],
            [ 'Випуск 3.503.1-93' ],
            [ 'Випуск 3.503-2' ],
            [ 'Випуск 384 сер.3.0503.12' ],
            [ 'Випуск 384/43' ],
            [ 'Випуск 384/45' ],
            [ 'Випуск 384/46' ],
            [ 'Випуск 56' ],
            [ 'Випуск 56-доповнення' ],
            [ 'Випуск 70' ],
            [ 'Випуск No332/1' ],
            [ 'Випуск No338/1' ],
            [ 'Випуск ІІ' ],
            [ 'Випуск-31' ],
            [ 'Відповідно до СПД' ],
            [ 'ВСК 31-87' ],
            [ 'ВТП 17 „Укрдіпродор”' ],
            [ 'ВТП 21-77' ],
            [ 'ВТП 21-79' ],
            [ 'ВТП 21-83' ],
            [ 'ВТП 21-86' ],
            [ 'ВТП-15' ],
            [ 'ВТП-16' ],
            [ 'ВТП-21' ],
            [ 'ВТП-26' ],
            [ 'ВТП-27/4М-85' ],
            [ 'Індивідуальний проект 1895 р.' ],
            [ 'Серія 3.503.1-61' ],
            [ 'Серія 3.503.1-81 випуск 5-5, 6-1' ],
            [ 'Серія 3.503.9-43/89' ],
            [ 'Серія 3.503-12' ],
            [ 'Серія 3.503-1-60.2' ],
            [ 'Серія 3.503-1-64.2' ],
            [ 'Серія 5-04-145' ],
            [ 'Союздорпроект "Випуск 122-62"' ],
            [ 'Союздорпроект "Випуск 143-144"' ],
            [ 'Союздорпроект "Випуск 791/6"' ],
            [ 'ТП 3.501-86' ],
            [ 'ТП 3.503-72.2' ],
            [ 'ТП 5-04-14' ],
        ]);

        // Table Б.41
        $this->createTable('overground_crossing_approach_type', [
            'overground_crossing_approach_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('overground_crossing_approach_type', 'Типи споруд підходів до надземних пішохідних переходів');
        $this->batchInsert('overground_crossing_approach_type', [ 'value' ], [
            [ 'сходи' ],
            [ 'ліфт' ],
            [ 'пандус' ],
        ]);

        // Table Б.42
        $this->createTable('sel_protection_type', [
            'sel_protection_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('sel_protection_type', 'Типи селезахисних споруд');
        $this->batchInsert('sel_protection_type', [ 'value' ], [
            [ 'накопичувальна дамба' ],
            [ 'струмененаправляюча дамба' ],
            [ 'фільтр-сепаратор' ],
        ]);

        // Table Б.43
        $this->createTable('culvert_obstacle_type', [
            'culvert_obstacle_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('culvert_obstacle_type', 'Види перешкод, які потребують водопропускних споруд');
        $this->batchInsert('culvert_obstacle_type', [ 'value' ], [
            [ 'суходіл' ],
            [ 'струмок' ],
            [ 'канал' ],
            [ 'болото' ],
            [ 'ставок' ],
            [ 'скотопрогін' ],
            [ 'з\'їзд вліво' ],
            [ 'з\'їзд вправо' ],
        ]);

        // Table Б.44
        $this->createTable('flow_direction', [
            'flow_direction_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('flow_direction', 'Напрямки течії, по відношенню до основної дороги');
        $this->batchInsert('flow_direction', [ 'value' ], [
            [ 'справа-наліво' ],
            [ 'зліва-направо' ],
        ]);

        // Table Б.45
        $this->createTable('culvert_element_work', [
            'culvert_element_work_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('culvert_element_work', 'Характер роботи водопропускного елементу');
        $this->batchInsert('culvert_element_work', [ 'value' ], [
            [ 'напірний' ],
            [ 'напівнапірний' ],
        ]);

        // Table Б.46
        $this->createTable('fortified_additional', [
            'fortified_additional_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('fortified_additional', 'Додаткові укріплення дна труб та оголовків');
        $this->batchInsert('fortified_additional', [ 'value' ], [
            [ 'цементообетонні плити омонолічені' ],
            [ 'цементообетонні плити не омонолічені' ],
            [ 'залізобетонні плити омонолічені' ],
            [ 'залізобетонні плити не омонолічені' ],
            [ 'кам\'яна кладка' ],
            [ 'монолітний цементобетон' ],
            [ 'асфальтобетон' ],
            [ 'накид каміння' ],
        ]);

        // Table Б.47
        $this->createTable('waterproof_type', [
            'waterproof_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('waterproof_type', 'Тип гідроізоляції');
        $this->batchInsert('waterproof_type', [ 'value' ], [
            [ 'оклеювальна' ],
            [ 'обмазувальна' ],
        ]);

        // Table Б.48
        $this->createTable('regulatory_type', [
            'regulatory_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('regulatory_type', 'Типи регуляційних елементів та гасників');
        $this->batchInsert('regulatory_type', [ 'value' ], [
            [ 'відсутні' ],
            [ 'водобійна яма' ],
            [ 'водобійний колодязь' ],
            [ 'водобійна стінка' ],
            [ 'лоток' ],
            [ 'перепади' ],
            [ 'швидкотік' ],
        ]);

        // Table Б.49
        $this->createTable('retaining_wall_type', [
            'retaining_wall_type_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('retaining_wall_type', 'Типи підпірних стінок (ДБН В.2.3-4)');
        $this->batchInsert('retaining_wall_type', [ 'value' ], [
            [ 'верхова' ],
            [ 'низова' ],
        ]);

        // Table Б.50
        $this->createTable('retaining_wall_purpose', [
            'retaining_wall_purpose_id' => $this->primaryKey()->comment('Ідентифікатор'),
            'value' => $this->string()->comment('Значення'),
        ]);
        $this->addCommentOnTable('retaining_wall_purpose', 'Призначення підпірних стінок (ДБН В.2.3-4)');
        $this->batchInsert('retaining_wall_purpose', [ 'value' ], [
            [ 'одягаюча' ],
            [ 'несуча' ],
        ]);
    
        // Table Demo1
        $this->createTable('surface_type', [
            'surface_type_id' => $this->primaryKey(),
            'name'            => $this->string(),
        ]);
        $this->batchInsert('surface_type', [ 'name' ], [
            [ 'асфальтобетон (горячий)' ],
        ]);
    
        // Table Demo2
        $this->createTable('surface_treatment', [
            'surface_treatment_id' => $this->primaryKey(),
            'name' => $this->string(),
        ]);
        $this->batchInsert('surface_treatment', [ 'name' ], [
            [ 'нема' ],
        ]);
    
        // Table Demo3
        $this->createTable('road_passport', [
            'road_passport_id' => $this->primaryKey(),
            'road_id' => $this->integer(),
            'region_id' => $this->integer(),
            'begin' => $this->float(),
            'end' => $this->float(),
        ]);
    
        // Table Demo4
        $this->createTable('point', [
            'point_id' => $this->primaryKey(),
            'road_passport_id' => $this->integer(),
            'lat' => $this->float(),
            'lng' => $this->float(),
            'km' => $this->float(),
            'num' => $this->integer(),
        ]);
    
        // Table Demo5
        $this->createTable('road_service', [
            'road_service_id' => $this->primaryKey(),
            'road_id' => $this->integer(),
            'region_id' => $this->integer(),
            'road_direction_id' => $this->integer(),
            'organization_id' => $this->integer(),
            'begin' => $this->float(),
            'end' => $this->float(),
            'year_begin' => $this->integer(),
        ]);
    
        // Table Demo6
        $this->createTable('settlement_address_link', [
            'settlement_address_link_id' => $this->primaryKey(),
            'road_id' => $this->integer(),
            'region_id' => $this->integer(),
            'settlement_location_id' => $this->integer(),
            'settlement_id' => $this->integer(),
            'begin' => $this->float(),
            'end' => $this->float(),
            'distance' => $this->float(),
        ]);
    }

    public function safeDown()
    {
        $this->dropTable('road');
        $this->dropTable('authority');
        $this->dropTable('contractor');
        $this->dropTable('digital_model');
        $this->dropTable('row');
        $this->dropTable('roadway');
        $this->dropTable('horizontal_curve_radius');
        $this->dropTable('road_surface');
        $this->dropTable('structural_layers');
        $this->dropTable('road_surface_strenght');
        $this->dropTable('road_surface_flatness');
        $this->dropTable('road_surface_clutch');
        $this->dropTable('road_surface_damage');
        $this->dropTable('roadbed_size');
        $this->dropTable('rally');
        $this->dropTable('rally_card');
        $this->dropTable('tunnel');
        $this->dropTable('tunnel_card');
        $this->dropTable('tunnel_portal_card');
        $this->dropTable('tunnel_body_card');
        $this->dropTable('sewage_card');
        $this->dropTable('technical_doc');
        $this->dropTable('bridge');
        $this->dropTable('bridge_card');
        $this->dropTable('purlin_card');
        $this->dropTable('pillar_card');
        $this->dropTable('underground_crossing');
        $this->dropTable('underground_crossing_card');
        $this->dropTable('underground_crossing_portal_card');
        $this->dropTable('underground_crossing_body_card');
        $this->dropTable('underground_crossing_add_on_card');
        $this->dropTable('overground_crossing');
        $this->dropTable('overground_crossing_card');
        $this->dropTable('overground_crossing_approach_card');
        $this->dropTable('sel_protection');
        $this->dropTable('sel_protection_card');
        $this->dropTable('drainage_pipe');
        $this->dropTable('drainage_pipe_card');
        $this->dropTable('culvert_element_card');
        $this->dropTable('header_card');
        $this->dropTable('bus_stop');
        $this->dropTable('bus_stop_card');
        $this->dropTable('pavilion_card');
        $this->dropTable('retaining_wall');
        $this->dropTable('retaining_wall_card');
        $this->dropTable('stabilisation_field');
        $this->dropTable('stabilisation_field_card');
        $this->dropTable('tray');
        $this->dropTable('tray_card');
        $this->dropTable('drainage');
        $this->dropTable('drainage_card');
        $this->dropTable('site');
        $this->dropTable('site_card');
        $this->dropTable('improvement_card');
        $this->dropTable('sidewalk');
        $this->dropTable('sidewalk_card');
        $this->dropTable('fence');
        $this->dropTable('fence_card');
        $this->dropTable('direct_device');
        $this->dropTable('direct_device_card');
        $this->dropTable('noise_dazzle_protection');
        $this->dropTable('dazzle_protection_card');
        $this->dropTable('noise_protection_card');
        $this->dropTable('road_sign');
        $this->dropTable('road_sign_card');
        $this->dropTable('road_mark');
        $this->dropTable('road_mark_card');
        $this->dropTable('planting');
        $this->dropTable('planting_card');
        $this->dropTable('data_collector');
        $this->dropTable('data_collector_card');
        $this->dropTable('communication');
        $this->dropTable('communication_card');
        $this->dropTable('snow_protection');
        $this->dropTable('topography_climate');
        $this->dropTable('road_complex');
        $this->dropTable('rail_cross');
        $this->dropTable('important_object');
        $this->dropTable('communication_third');
        $this->dropTable('communication_third_card');
        $this->dropTable('flow');
        $this->dropTable('speed_limit');
        $this->dropTable('visibility_danger');
        $this->dropTable('road_accident');
        $this->dropTable('road_maintenance_finance_plan');
    
        $this->dropTable('road_maintenance_finance_fact');
    
        $this->dropTable('road_maintenance_state');
    
        $this->dropTable('critical_situation');
    
        $this->dropTable('repair_work');
    
        $this->dropTable('horizontal_curve_direction');
    
        $this->dropTable('movement_direction');
    
        $this->dropTable('position_according_road');
    
        $this->dropTable('availability');
    
        $this->dropTable('road_type');
    
        $this->dropTable('road_category');
    
        $this->dropTable('state_production');
    
        $this->dropTable('bitumen_storage_type');
    
        $this->dropTable('state');
    
        $this->dropTable('storage_type');
    
        $this->dropTable('vehicle_type');
    
        $this->dropTable('obstacle_up');
    
        $this->dropTable('land_soil');
    
        $this->dropTable('state_common');
    
        $this->dropTable('ventilation_type');
    
        $this->dropTable('light_type');
    
        $this->dropTable('antiseismic_type');
    
        $this->dropTable('communication_type');
    
        $this->dropTable('header_purpose');
    
        $this->dropTable('header_type');
    
        $this->dropTable('body_material');
    
        $this->dropTable('foundation_material');
    
        $this->dropTable('basement_material');
    
        $this->dropTable('fortified_slope_material');
    
        $this->dropTable('body_type');
    
        $this->dropTable('span_scheme');
    
        $this->dropTable('span_type');
    
        $this->dropTable('load_project');
    
        $this->dropTable('bearing_moving_type');
    
        $this->dropTable('bearing_not_moving_type');
    
        $this->dropTable('cross_joint_type');
    
        $this->dropTable('pillar_type');
    
        $this->dropTable('pillar_body_material');
    
        $this->dropTable('pillar_foundation_type');
    
        $this->dropTable('icebreaker_type');
    
        $this->dropTable('icebreaker_material');
    
        $this->dropTable('wall_material');
    
        $this->dropTable('roof_material');
    
        $this->dropTable('drainage_type');
    
        $this->dropTable('span_project');
    
        $this->dropTable('overground_crossing_approach_type');
    
        $this->dropTable('sel_protection_type');
    
        $this->dropTable('culvert_obstacle_type');
    
        $this->dropTable('flow_direction');
    
        $this->dropTable('culvert_element_work');
    
        $this->dropTable('fortified_additional');
    
        $this->dropTable('waterproof_type');
    
        $this->dropTable('regulatory_type');
    
        $this->dropTable('retaining_wall_type');
    
        $this->dropTable('retaining_wall_purpose');
        
        $this->dropTable('surface_type');
        
        $this->dropTable('surface_treatment');
        
        $this->dropTable('road_passport');
    
        $this->dropTable('point');
        $this->dropTable('road_service');
        $this->dropTable('settlement_address_link');

    }
}
