<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "surface_treatment".
 *
 * @property integer $surface_treatment_id
 * @property string $name
 *
 * @property RoadSurface[] $roadSurfaces
 */
class SurfaceTreatment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'surface_treatment';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'surface_treatment_id' => 'Surface Treatment ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadSurfaces()
    {
        return $this->hasMany(RoadSurface::className(), ['surface_treatment_id' => 'surface_treatment_id']);
    }
}
