<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\SettlementAddressLink;

/**
 * SettlementAddressLinkSearch represents the model behind the search form about `common\models\SettlementAddressLink`.
 */
class SettlementAddressLinkSearch extends SettlementAddressLink
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['settlement_address_link_id', 'road_id', 'region_id', 'settlement_location_id', 'settlement_id'], 'integer'],
            [['begin', 'end', 'distance'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SettlementAddressLink::find()->joinWith(['road', 'region', 'settlement', 'settlementLocation']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'settlement_address_link_id' => $this->settlement_address_link_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'begin' => $this->begin,
            'end' => $this->end,
            'settlement_location_id' => $this->settlement_location_id,
            'settlement_id' => $this->settlement_id,
            'distance' => $this->distance,
        ]);

        return $dataProvider;
    }
}
