<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\RoadWidth;

/**
 * RoadWidthSearch represents the model behind the search form about `common\models\RoadWidth`.
 */
class RoadWidthSearch extends RoadWidth
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_width_id', 'region_id', 'road_id'], 'integer'],
            [['begin', 'end', 'width_roadside_left', 'width_reverse_road', 'width_strip', 'width_roadway_forward', 'width_roadside_right', 'count_lane_left', 'count_lane_right'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = RoadWidth::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'road_width_id' => $this->road_width_id,
            'region_id' => $this->region_id,
            'road_id' => $this->road_id,
            'begin' => $this->begin,
            'end' => $this->end,
            'width_roadside_left' => $this->width_roadside_left,
            'width_reverse_road' => $this->width_reverse_road,
            'width_strip' => $this->width_strip,
            'width_roadway_forward' => $this->width_roadway_forward,
            'width_roadside_right' => $this->width_roadside_right,
            'count_lane_left' => $this->count_lane_left,
            'count_lane_right' => $this->count_lane_right,
        ]);

        return $dataProvider;
    }
}
