<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road_width".
 *
 * @property integer $road_width_id
 * @property integer $region_id
 * @property integer $road_id
 * @property double $begin
 * @property double $end
 * @property double $width_roadside_left
 * @property double $width_reverse_road
 * @property double $width_strip
 * @property double $width_roadway_forward
 * @property double $width_roadside_right
 * @property double $count_lane_left
 * @property double $count_lane_right
 *
 * @property Region $region
 * @property Road $road
 */
class RoadWidth extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road_width';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['region_id', 'road_id'], 'integer'],
            [['begin', 'end', 'width_roadside_left', 'width_reverse_road', 'width_strip', 'width_roadway_forward', 'width_roadside_right', 'count_lane_left', 'count_lane_right'], 'number'],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_width_id' => 'Індекс',
            'region_id' => 'Область',
            'road_id' => 'Дорога',
            'begin' => 'Місцезнаходженя, км+ початок',
            'end' => 'Місцезнаходженя, км+ кінець',
            'width_roadside_left' => 'Ширина, узбіччя зліва',
            'width_reverse_road' => 'Ширина, проїзна зворотнього напрямку',
            'width_strip' => 'Ширина, розподільча смуга',
            'width_roadway_forward' => 'Ширина, проїзна прямого напрямку',
            'width_roadside_right' => 'Ширина, узбіччя справа',
            'count_lane_left' => 'Кількість смуг руху зліва',
            'count_lane_right' => 'Кількість смуг руху справа',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id']);
    }

    public function getBeginString()
    {
        return floor($this->begin) . '+' . ( str_pad(round(( $this->begin - floor($this->begin) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getEndString()
    {
        return floor($this->end) . '+' . ( str_pad(round(( $this->end - floor($this->end) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }
}
