<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\RoadToCategory;

/**
 * RoadToCategorySearch represents the model behind the search form about `common\models\RoadToCategory`.
 */
class RoadToCategorySearch extends RoadToCategory
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_to_category_id', 'region_id', 'road_id', 'road_category_id'], 'integer'],
            [['begin', 'end', 'distance'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = RoadToCategory::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'road_to_category_id' => $this->road_to_category_id,
            'region_id' => $this->region_id,
            'road_id' => $this->road_id,
            'begin' => $this->begin,
            'end' => $this->end,
            'distance' => $this->distance,
            'road_category_id' => $this->road_category_id,
        ]);

        return $dataProvider;
    }
}
