<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\RoadSurface;

/**
 * RoadSurfaceSearch represents the model behind the search form about `common\models\RoadSurface`.
 */
class RoadSurfaceSearch extends RoadSurface
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_surface_id', 'road_id', 'region_id', 'road_direction_id', 'surface_type_id', 'surface_treatment_id', 'state_common_id'], 'integer'],
            [['begin', 'end'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = RoadSurface::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'road_surface_id' => $this->road_surface_id,
            'road_id' => $this->road_id,
            'region_id' => $this->region_id,
            'road_direction_id' => $this->road_direction_id,
            'begin' => $this->begin,
            'end' => $this->end,
            'surface_type_id' => $this->surface_type_id,
            'surface_treatment_id' => $this->surface_treatment_id,
            'state_common_id' => $this->state_common_id,
        ]);

        return $dataProvider;
    }
}
