<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "road".
 *
 * @property integer $road_id
 * @property string $name
 * @property integer $road_type_id
 * @property integer $index
 *
 * @property RoadType $roadType
 * @property RoadPassport[] $roadPassports
 */
class Road extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'road';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_type_id', 'name', 'index'], 'required'],
            [['road_type_id', 'index'], 'integer'],
            [['index'], 'default', 'value' => 0],
            [['name'], 'string', 'max' => 255],
            [['road_type_id', 'index'], 'unique', 'skipOnError' => true, 'targetAttribute' => ['road_type_id', 'index'], 'message' => 'The combination of Road Type ID and Index has already been taken.'],
            [['road_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoadType::className(), 'targetAttribute' => ['road_type_id' => 'road_type_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'road_id' => 'Road ID',
            'name' => 'Назва дороги',
            'road_type_id' => 'Тип дороги',
            'index' => 'Індекс дороги',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadType()
    {
        return $this->hasOne(RoadType::className(), ['road_type_id' => 'road_type_id'])->inverseOf('roads');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadPassports()
    {
        return $this->hasMany(RoadPassport::className(), ['road_id' => 'road_id'])->inverseOf('road');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadServices()
    {
        return $this->hasMany(RoadService::className(), [ 'road_id' => 'road_id' ])
                    ->inverseOf('road');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlementAddressLinks()
    {
        return $this->hasOne(SettlementAddressLink::className(), ['road_id' => 'road_id'])->inverseOf('road');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFlowIntensities()
    {
        return $this->hasOne(FlowIntensity::className(), [ 'road_id' => 'road_id' ])
                    ->inverseOf('road');
    }
}
