<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "region".
 *
 * @property integer $region_id
 * @property string $name
 * @property integer $index
 *
 * @property RoadPassport[] $roadPassports
 */
class Region extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'region';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['index'], 'integer'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'region_id' => 'Region ID',
            'name' => 'Name',
            'index' => 'Index',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadPassports()
    {
        return $this->hasMany(RoadPassport::className(), ['region_id' => 'region_id'])->inverseOf('region');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadServices()
    {
        return $this->hasMany(RoadService::className(), [ 'region_id' => 'region_id' ])
                    ->inverseOf('region');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlementAddressLinks()
    {
        return $this->hasOne(SettlementAddressLink::className(), ['region' => 'region_id'])->inverseOf('region');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFlowIntensities()
    {
        return $this->hasOne(FlowIntensity::className(), [ 'region_id' => 'region_id' ])
                    ->inverseOf('region');
    }
}
